/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.Test;

public class ManagedRouteRestartTest
extends ManagementTestSupport {
    private MyRoutePolicy myRoutePolicy = new MyRoutePolicy();

    @Test
    public void testRestartRoute() throws Exception {
        if (ManagedRouteRestartTest.isPlatform((String)"aix")) {
            return;
        }
        ManagedRouteRestartTest.assertEquals((long)1L, (long)this.myRoutePolicy.getStart());
        ManagedRouteRestartTest.assertEquals((long)0L, (long)this.myRoutePolicy.getStop());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteRestartTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteRestartTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRouteRestartTest.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRestartTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedRouteRestartTest.assertNotNull((Object)uptime);
        this.log.info("Uptime: {}", (Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        ManagedRouteRestartTest.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        mbeanServer.invoke(on, "restart", null, null);
        registered = mbeanServer.isRegistered(on);
        ManagedRouteRestartTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRestartTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        ManagedRouteRestartTest.assertEquals((long)2L, (long)this.myRoutePolicy.getStart());
        ManagedRouteRestartTest.assertEquals((long)1L, (long)this.myRoutePolicy.getStop());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{ManagedRouteRestartTest.this.myRoutePolicy}).delayer(10L).to("log:foo")).to("mock:result");
            }
        };
    }

    private final class MyRoutePolicy
    extends RoutePolicySupport {
        private int start;
        private int stop;

        private MyRoutePolicy() {
        }

        public void onStart(Route route) {
            ++this.start;
        }

        public void onStop(Route route) {
            ++this.stop;
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.stop;
        }
    }
}

