/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRouteGetPropertiesTest
extends ManagementTestSupport {
    @Test
    public void testGetProperties() throws Exception {
        if (ManagedRouteGetPropertiesTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteGetPropertiesTest.getRouteObjectName(mbeanServer);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteGetPropertiesTest.assertEquals((Object)"myRoute", (Object)routeId);
        TabularData data = (TabularData)mbeanServer.invoke(on, "getRouteProperties", null, null);
        ManagedRouteGetPropertiesTest.assertNotNull((Object)data);
        ManagedRouteGetPropertiesTest.assertTrue((boolean)data.containsKey(new Object[]{"key1"}));
        ManagedRouteGetPropertiesTest.assertEquals((Object)"key1", (Object)data.get(new Object[]{"key1"}).get("key"));
        ManagedRouteGetPropertiesTest.assertEquals((Object)"val1", (Object)data.get(new Object[]{"key1"}).get("value"));
        ManagedRouteGetPropertiesTest.assertTrue((boolean)data.containsKey(new Object[]{"key2"}));
        ManagedRouteGetPropertiesTest.assertEquals((Object)"key2", (Object)data.get(new Object[]{"key2"}).get("key"));
        ManagedRouteGetPropertiesTest.assertEquals((Object)"val2", (Object)data.get(new Object[]{"key2"}).get("value"));
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteGetPropertiesTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("myRoute").routeProperty("key1", "val1").routeProperty("key2", "val2").to("mock:result");
            }
        };
    }
}

