/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultExchange;
import org.junit.Test;

public class ManagedRouteAddFromRouteTest
extends ManagementTestSupport {
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SedaEndpoint seda = (SedaEndpoint)ManagedRouteAddFromRouteTest.this.context.getEndpoint("seda:start", SedaEndpoint.class);
                seda.getQueue().put(new DefaultExchange((CamelContext)ManagedRouteAddFromRouteTest.this.context));
                ((RouteDefinition)this.from("seda:start").routeId("foo").process(exchange -> {
                    RouteBuilder child = new RouteBuilder(){

                        public void configure() throws Exception {
                            this.from("seda:bar").routeId("bar").to("mock:bar");
                        }
                    };
                    ManagedRouteAddFromRouteTest.this.context.addRoutes((RoutesBuilder)child);
                })).to("mock:result");
            }
        };
    }

    @Test
    public void testAddRouteFromRoute() throws Exception {
        if (ManagedRouteAddFromRouteTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName route1 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        String state = (String)mbeanServer.getAttribute(route1, "State");
        ManagedRouteAddFromRouteTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        result.assertIsSatisfied();
        ObjectName route2 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"bar\"");
        state = (String)mbeanServer.getAttribute(route2, "State");
        ManagedRouteAddFromRouteTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
    }
}

