/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRegisterTwoRoutesTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        if (ManagedRegisterTwoRoutesTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRegisterTwoRoutesTest.assertEquals((long)2L, (long)set.size());
        HashSet<String> uris = new HashSet<String>();
        for (ObjectName on : set) {
            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            uris.add(uri);
        }
        ManagedRegisterTwoRoutesTest.assertTrue((boolean)uris.contains("direct://start"));
        ManagedRegisterTwoRoutesTest.assertTrue((boolean)uris.contains("direct://foo"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

