/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.Test;

public class ManagedLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testLoadBalancer() throws Exception {
        if (ManagedLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World", "Hi World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://a\"");
        Long queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        ManagedLoadBalancerTest.assertEquals((long)2L, (long)queueSize.intValue());
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://b\"");
        queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        ManagedLoadBalancerTest.assertEquals((long)1L, (long)queueSize.intValue());
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"myBalancer\"");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        ManagedLoadBalancerTest.assertEquals((long)3L, (long)total.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").routeId("foo").loadBalance().id("myBalancer")).roundRobin().to("mock:a")).to("mock:b");
            }
        };
    }
}

