/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Predicate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedFilterTest
extends ManagementTestSupport {
    @Test
    public void testManageFilter() throws Exception {
        if (ManagedFilterTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedFilterTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedFilterTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedFilterTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Long count = (Long)mbeanServer.getAttribute(on, "FilteredCount");
        ManagedFilterTest.assertEquals((long)1L, (long)count);
        String lan = (String)mbeanServer.getAttribute(on, "PredicateLanguage");
        ManagedFilterTest.assertEquals((Object)"header", (Object)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Predicate");
        ManagedFilterTest.assertEquals((Object)"foo", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").filter((Predicate)this.header("foo")).id("mysend").to("mock:foo");
            }
        };
    }
}

