/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedErrorHandlerTest
extends ManagementTestSupport {
    @Test
    public void testManagedErrorHandler() throws Exception {
        if (ManagedErrorHandlerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedErrorHandlerTest.assertEquals((long)2L, (long)set.size());
        Iterator<ObjectName> it = set.iterator();
        ObjectName on1 = it.next();
        ObjectName on2 = it.next();
        String name1 = on1.getCanonicalName();
        String name2 = on2.getCanonicalName();
        ManagedErrorHandlerTest.assertTrue((String)"Should be a default error handler", (name1.contains("CamelDefaultErrorHandlerBuilder") || name2.contains("CamelDefaultErrorHandlerBuilder") ? 1 : 0) != 0);
        ManagedErrorHandlerTest.assertTrue((String)"Should be a dead letter error handler", (name1.contains("DeadLetterChannelBuilder") || name2.contains("DeadLetterChannelBuilder") ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead")).to("mock:bar");
                this.from("direct:baz").to("mock:baz");
            }
        };
    }
}

