/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Assert;
import org.junit.Test;

public class ManagedDefaultReactiveExecutorTest
extends ManagementTestSupport {
    @Test
    public void testReactiveExecutor() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        MBeanServer mbeanServer = ManagedDefaultReactiveExecutorTest.this.getMBeanServer();
                        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,name=DefaultReactiveExecutor");
                        Assert.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
                        Integer running = (Integer)mbeanServer.getAttribute(on, "RunningWorkers");
                        Assert.assertEquals((long)1L, (long)running.intValue());
                        Long pending = (Long)mbeanServer.getAttribute(on, "PendingTasks");
                        Assert.assertEquals((long)0L, (long)pending.intValue());
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

