/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.junit.Test;

public class ManagedCustomPolicyTest
extends ManagementTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    @Test
    public void testPolicy() throws Exception {
        if (ManagedCustomPolicyTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        ManagedCustomPolicyTest.assertEquals((long)1L, (long)this.counter.get());
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedCustomPolicyTest.assertEquals((long)3L, (long)set.size());
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"foo\"");
        ManagedCustomPolicyTest.assertTrue((String)"Should be registered: foo", (boolean)mbeanServer.isRegistered(on));
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"result\"");
        ManagedCustomPolicyTest.assertTrue((String)"Should be registered: result", (boolean)mbeanServer.isRegistered(on));
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"bar\"");
        ManagedCustomPolicyTest.assertTrue((String)"Should be registered: bar", (boolean)mbeanServer.isRegistered(on));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy((Policy)new MyPolicy()).to("log:foo")).id("foo")).to("mock:result")).id("result");
                ((RouteDefinition)this.from("direct:bar").to("log:bar")).id("bar");
            }
        };
    }

    private final class MyPolicy
    implements Policy {
        private MyPolicy() {
        }

        public void beforeWrap(RouteContext routeContext, NamedNode definition) {
        }

        public Processor wrap(RouteContext routeContext, Processor processor) {
            return exchange -> {
                ManagedCustomPolicyTest.this.counter.incrementAndGet();
                processor.process(exchange);
            };
        }
    }
}

