/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultConsumerCache;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedConsumerCacheHitsTest
extends ManagementTestSupport {
    @Test
    public void testManageConsumerCache() throws Exception {
        if (ManagedConsumerCacheHitsTest.isPlatform((String)"aix")) {
            return;
        }
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        DefaultConsumerCache cache = new DefaultConsumerCache((Object)this, (CamelContext)this.context, 0);
        this.context.addService((Object)cache);
        this.template.sendBody("seda:a", (Object)"Hello World");
        Exchange out = cache.acquirePollingConsumer(this.context.getEndpoint("seda:a")).receive(3000L);
        ManagedConsumerCacheHitsTest.assertNotNull((String)"Should got an exchange", (Object)out);
        ManagedConsumerCacheHitsTest.assertEquals((Object)"Hello World", (Object)out.getIn().getBody());
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("ConsumerCache")) continue;
            on = name;
            break;
        }
        ManagedConsumerCacheHitsTest.assertNotNull((String)"Should have found ConsumerCache", on);
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        ManagedConsumerCacheHitsTest.assertEquals((long)1000L, (long)max.intValue());
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedConsumerCacheHitsTest.assertEquals((long)1L, (long)current.intValue());
        Long hits = (Long)mbeanServer.getAttribute(on, "Hits");
        ManagedConsumerCacheHitsTest.assertEquals((long)0L, (long)hits);
        Long misses = (Long)mbeanServer.getAttribute(on, "Misses");
        ManagedConsumerCacheHitsTest.assertEquals((long)1L, (long)misses);
        this.template.sendBody("seda:b", (Object)"Hello World");
        this.template.sendBody("seda:c", (Object)"Hello World");
        out = cache.acquirePollingConsumer(this.context.getEndpoint("seda:b")).receive(3000L);
        ManagedConsumerCacheHitsTest.assertNotNull((Object)out);
        out = cache.acquirePollingConsumer(this.context.getEndpoint("seda:c")).receive(3000L);
        ManagedConsumerCacheHitsTest.assertNotNull((Object)out);
        hits = (Long)mbeanServer.getAttribute(on, "Hits");
        ManagedConsumerCacheHitsTest.assertEquals((long)0L, (long)hits);
        misses = (Long)mbeanServer.getAttribute(on, "Misses");
        ManagedConsumerCacheHitsTest.assertEquals((long)3L, (long)misses);
        this.template.sendBody("seda:a", (Object)"Bye World");
        this.template.sendBody("seda:b", (Object)"Bye World");
        out = cache.acquirePollingConsumer(this.context.getEndpoint("seda:a")).receive(3000L);
        ManagedConsumerCacheHitsTest.assertNotNull((Object)out);
        out = cache.acquirePollingConsumer(this.context.getEndpoint("seda:b")).receive(3000L);
        ManagedConsumerCacheHitsTest.assertNotNull((Object)out);
        hits = (Long)mbeanServer.getAttribute(on, "Hits");
        ManagedConsumerCacheHitsTest.assertEquals((long)2L, (long)hits);
        misses = (Long)mbeanServer.getAttribute(on, "Misses");
        ManagedConsumerCacheHitsTest.assertEquals((long)3L, (long)misses);
        mbeanServer.invoke(on, "resetStatistics", null, null);
        hits = (Long)mbeanServer.getAttribute(on, "Hits");
        ManagedConsumerCacheHitsTest.assertEquals((long)0L, (long)hits);
        misses = (Long)mbeanServer.getAttribute(on, "Misses");
        ManagedConsumerCacheHitsTest.assertEquals((long)0L, (long)misses);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

