/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedCamelContextUpdateRoutesFromXmlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsXml() throws Exception {
        if (ManagedCamelContextUpdateRoutesFromXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedCamelContextUpdateRoutesFromXmlTest.assertEquals((long)1L, (long)set.size());
        String xml = "<routes id=\"myRoute\" xmlns=\"http://camel.apache.org/schema/spring\"><route id=\"myRoute\">  <from uri=\"direct:start\"/>  <log message=\"This is a changed route saying ${body}\"/>  <to uri=\"mock:changed\"/></route><route id=\"myOtherRoute\">  <from uri=\"seda:bar\"/>  <to uri=\"mock:bar\"/></route></routes>";
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        mbeanServer.invoke(on, "addOrUpdateRoutesFromXml", new Object[]{xml}, new String[]{"java.lang.String"});
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedCamelContextUpdateRoutesFromXmlTest.assertEquals((long)2L, (long)set.size());
        this.getMockEndpoint("mock:changed").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("mock:result");
            }
        };
    }
}

