/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Before;
import org.junit.Test;

public class ManagedBrowsableEndpointAsXmlFileTest
extends ManagementTestSupport {
    @Override
    @Before
    public void setUp() throws Exception {
        ManagedBrowsableEndpointAsXmlFileTest.deleteDirectory((String)"target/data/files");
        super.setUp();
    }

    @Test
    public void testBrowseableEndpointAsXmlAllIncludeBody() throws Exception {
        if (ManagedBrowsableEndpointAsXmlFileTest.isPlatform((String)"aix")) {
            return;
        }
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"file://target/data/files\"");
        String out = (String)mbeanServer.invoke(name, "browseAllMessagesAsXml", new Object[]{true}, new String[]{"java.lang.Boolean"});
        ManagedBrowsableEndpointAsXmlFileTest.assertNotNull((Object)out);
        this.log.info(out);
        ManagedBrowsableEndpointAsXmlFileTest.assertTrue((String)"Should contain the body", (boolean)out.contains("Hello World</body>"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedBrowsableEndpointAsXmlFileTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                this.from("direct:start").to("file:target/data/files");
            }
        };
    }
}

