/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class BacklogTracerStreamCachingTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerEventMessageStreamCaching() throws Exception {
        if (BacklogTracerStreamCachingTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        BacklogTracerStreamCachingTest.assertNotNull((Object)on);
        BacklogTracerStreamCachingTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogTracerStreamCachingTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        BacklogTracerStreamCachingTest.assertEquals((String)"Should be 1000", (long)1000L, (long)size.intValue());
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        BacklogTracerStreamCachingTest.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("BodyIncludeStreams", Boolean.TRUE));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:bar").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogTracerStreamCachingTest.assertNotNull((Object)events);
        BacklogTracerStreamCachingTest.assertEquals((long)1L, (long)events.size());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(0);
        BacklogTracerStreamCachingTest.assertEquals((Object)"bar", (Object)event1.getToNode());
        BacklogTracerStreamCachingTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\">\n      <body type=\"org.apache.camel.converter.stream.ByteArrayInputStreamCache\">Bye World</body>\n    </message>"), (Object)event1.getMessageAsXml());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerStreamCachingTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerStreamCachingTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").streamCaching().process(exchange -> {
                    ByteArrayInputStream is = new ByteArrayInputStream("Bye World".getBytes());
                    exchange.getIn().setBody((Object)is);
                })).log("Got ${body}")).to("mock:bar")).id("bar");
            }
        };
    }
}

