/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class LanguageLoadScriptFromFileCachedTest
extends ContextTestSupport {
    @Before
    public void setUp() throws Exception {
        LanguageLoadScriptFromFileCachedTest.deleteDirectory((String)"target/data/script");
        super.setUp();
    }

    public boolean useJmx() {
        return true;
    }

    @Test
    public void testLanguage() throws Exception {
        this.template.sendBodyAndHeader("file:target/data/script", (Object)"Hello ${body}", "CamelFileName", (Object)"myscript.txt");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBodyAndHeader("file:target/data/script", (Object)"Bye ${body}", "CamelFileName", (Object)"myscript.txt");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testClearCachedScriptViaJmx() throws Exception {
        this.template.sendBodyAndHeader("file:target/data/script", (Object)"Hello ${body}", "CamelFileName", (Object)"myscript.txt");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBodyAndHeader("file:target/data/script", (Object)"Bye ${body}", "CamelFileName", (Object)"myscript.txt");
        this.template.sendBody("direct:start", (Object)"World");
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> objNameSet = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=endpoints,name=\"language://simple:*contentCache=true*\",*"), null);
        ObjectName managedObjName = new ArrayList<ObjectName>(objNameSet).get(0);
        mbeanServer.invoke(managedObjName, "clearContentCache", null, null);
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("language:simple:file:target/data/script/myscript.txt?contentCache=true&cacheScript=true")).to("mock:result");
            }
        };
    }
}

