/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kotlin.model.rest;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.kotlin.CamelDslMarker;
import org.apache.camel.kotlin.model.rest.ApiKeyDsl;
import org.apache.camel.kotlin.model.rest.BasicAuthDsl;
import org.apache.camel.kotlin.model.rest.BearerTokenDsl;
import org.apache.camel.kotlin.model.rest.MutualTLSDsl;
import org.apache.camel.kotlin.model.rest.OAuth2Dsl;
import org.apache.camel.kotlin.model.rest.OpenIdConnectDsl;
import org.apache.camel.model.rest.ApiKeyDefinition;
import org.apache.camel.model.rest.BasicAuthDefinition;
import org.apache.camel.model.rest.BearerTokenDefinition;
import org.apache.camel.model.rest.MutualTLSDefinition;
import org.apache.camel.model.rest.OAuth2Definition;
import org.apache.camel.model.rest.OpenIdConnectDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.jetbrains.annotations.NotNull;

@CamelDslMarker
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u000f\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u0011\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u0013\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u0015\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u0017\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/apache/camel/kotlin/model/rest/RestSecuritiesDsl;", "", "def", "Lorg/apache/camel/model/rest/RestSecuritiesDefinition;", "rest", "Lorg/apache/camel/model/rest/RestDefinition;", "(Lorg/apache/camel/model/rest/RestSecuritiesDefinition;Lorg/apache/camel/model/rest/RestDefinition;)V", "getDef", "()Lorg/apache/camel/model/rest/RestSecuritiesDefinition;", "apiKey", "", "i", "Lkotlin/Function1;", "Lorg/apache/camel/kotlin/model/rest/ApiKeyDsl;", "Lkotlin/ExtensionFunctionType;", "basicAuth", "Lorg/apache/camel/kotlin/model/rest/BasicAuthDsl;", "bearer", "Lorg/apache/camel/kotlin/model/rest/BearerTokenDsl;", "mutualTLS", "Lorg/apache/camel/kotlin/model/rest/MutualTLSDsl;", "oauth2", "Lorg/apache/camel/kotlin/model/rest/OAuth2Dsl;", "openIdConnect", "Lorg/apache/camel/kotlin/model/rest/OpenIdConnectDsl;", "camel-kotlin-api"})
public final class RestSecuritiesDsl {
    @NotNull
    private final RestSecuritiesDefinition def;
    @NotNull
    private final RestDefinition rest;

    public RestSecuritiesDsl(@NotNull RestSecuritiesDefinition def, @NotNull RestDefinition rest) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.def = def;
        this.rest = rest;
    }

    @NotNull
    public final RestSecuritiesDefinition getDef() {
        return this.def;
    }

    public final void apiKey(@NotNull Function1<? super ApiKeyDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        ApiKeyDefinition apiKeyDef = new ApiKeyDefinition(this.rest);
        ApiKeyDsl apiKeyDsl = new ApiKeyDsl(apiKeyDef);
        i.invoke((Object)apiKeyDsl);
        this.def.getSecurityDefinitions().add(apiKeyDef);
    }

    public final void basicAuth(@NotNull Function1<? super BasicAuthDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        BasicAuthDefinition basicAuthDef = new BasicAuthDefinition(this.rest);
        BasicAuthDsl basicAuthDsl = new BasicAuthDsl(basicAuthDef);
        i.invoke((Object)basicAuthDsl);
        this.def.getSecurityDefinitions().add(basicAuthDef);
    }

    public final void bearer(@NotNull Function1<? super BearerTokenDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        BearerTokenDefinition bearerDef = new BearerTokenDefinition(this.rest);
        BearerTokenDsl bearerTokenDsl = new BearerTokenDsl(bearerDef);
        i.invoke((Object)bearerTokenDsl);
        this.def.getSecurityDefinitions().add(bearerDef);
    }

    public final void oauth2(@NotNull Function1<? super OAuth2Dsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        OAuth2Definition oauth2Def = new OAuth2Definition(this.rest);
        OAuth2Dsl oAuth2Dsl = new OAuth2Dsl(oauth2Def);
        i.invoke((Object)oAuth2Dsl);
        this.def.getSecurityDefinitions().add(oauth2Def);
    }

    public final void openIdConnect(@NotNull Function1<? super OpenIdConnectDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        OpenIdConnectDefinition openIdConnectDef = new OpenIdConnectDefinition(this.rest);
        OpenIdConnectDsl openIdConnectDsl = new OpenIdConnectDsl(openIdConnectDef);
        i.invoke((Object)openIdConnectDsl);
        this.def.getSecurityDefinitions().add(openIdConnectDef);
    }

    public final void mutualTLS(@NotNull Function1<? super MutualTLSDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        MutualTLSDefinition mutualTLSDef = new MutualTLSDefinition(this.rest);
        MutualTLSDsl mutualTLSDsl = new MutualTLSDsl(mutualTLSDef);
        i.invoke((Object)mutualTLSDsl);
        this.def.getSecurityDefinitions().add(mutualTLSDef);
    }
}

