/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kotlin.model.rest;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.kotlin.CamelDslMarker;
import org.apache.camel.kotlin.model.rest.ResponseHeaderDsl;
import org.apache.camel.model.rest.ResponseHeaderDefinition;
import org.apache.camel.model.rest.ResponseMessageDefinition;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.jetbrains.annotations.NotNull;

@CamelDslMarker
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u001f\u0010\u0010\u001a\u00020\b2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u0012\u00a2\u0006\u0002\b\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/apache/camel/kotlin/model/rest/ResponseMessageDsl;", "", "def", "Lorg/apache/camel/model/rest/ResponseMessageDefinition;", "(Lorg/apache/camel/model/rest/ResponseMessageDefinition;)V", "getDef", "()Lorg/apache/camel/model/rest/ResponseMessageDefinition;", "code", "", "", "", "description", "responseModel", "withExample", "key", "value", "withHeader", "i", "Lkotlin/Function1;", "Lorg/apache/camel/kotlin/model/rest/ResponseHeaderDsl;", "Lkotlin/ExtensionFunctionType;", "camel-kotlin-api"})
public final class ResponseMessageDsl {
    @NotNull
    private final ResponseMessageDefinition def;

    public ResponseMessageDsl(@NotNull ResponseMessageDefinition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        this.def = def;
    }

    @NotNull
    public final ResponseMessageDefinition getDef() {
        return this.def;
    }

    public final void code(int code) {
        this.def.setCode(String.valueOf(code));
    }

    public final void code(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.def.setCode(code);
    }

    public final void description(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.def.setMessage(description);
    }

    public final void responseModel(@NotNull String responseModel) {
        Intrinsics.checkNotNullParameter((Object)responseModel, (String)"responseModel");
        this.def.setResponseModel(responseModel);
    }

    public final void withHeader(@NotNull Function1<? super ResponseHeaderDsl, Unit> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        if (this.def.getHeaders() == null) {
            this.def.setHeaders((List)new ArrayList());
        }
        ResponseHeaderDefinition headerDef = new ResponseHeaderDefinition(this.def);
        ResponseHeaderDsl responseHeaderDsl = new ResponseHeaderDsl(headerDef);
        i.invoke((Object)responseHeaderDsl);
        this.def.getHeaders().add(headerDef);
    }

    public final void withExample(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.def.getExamples() == null) {
            this.def.setExamples((List)new ArrayList());
        }
        this.def.getExamples().add(new RestPropertyDefinition(key, value));
    }
}

