/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.scp.ScpConfiguration;
import org.apache.camel.component.scp.ScpEndpoint;
import org.apache.camel.component.scp.ScpFile;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpOperations
implements RemoteFileOperations<ScpFile> {
    private static final Logger LOG = LoggerFactory.getLogger(ScpOperations.class);
    private ScpEndpoint endpoint;
    private Session session;
    private ChannelExec channel;
    private String userKnownHostFile;

    public GenericFile<ScpFile> newGenericFile() {
        return new RemoteFile();
    }

    public void setEndpoint(GenericFileEndpoint<ScpFile> endpoint) {
        this.endpoint = (ScpEndpoint)endpoint;
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'delete' not supported by the scp: protocol");
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        return false;
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'rename' not supported by the scp: protocol");
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        return true;
    }

    public boolean retrieveFile(String name, Exchange exchange, long isze) throws GenericFileOperationFailedException {
        return false;
    }

    public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
    }

    public boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        ObjectHelper.notNull((Object)this.session, (String)"session");
        ScpConfiguration cfg = this.endpoint.getConfiguration();
        int timeout = cfg.getConnectTimeout();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Opening channel to {} with {} timeout...", (Object)cfg.remoteServerInformation(), timeout > 0 ? Integer.toString(timeout) + " ms" : "no");
        }
        String file = ScpOperations.getRemoteFile(name, cfg);
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                is = new ByteArrayInputStream(new byte[0]);
            } else {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
        }
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(ScpOperations.getScpCommand(cfg, file));
            this.channel.connect(timeout);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Channel connected to {}", (Object)cfg.remoteServerInformation());
            }
            try {
                if (is == null) {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
                this.write(this.channel, file, is, cfg);
            }
            catch (InvalidPayloadException e) {
                throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException("Failed to write file " + file, (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        catch (JSchException e) {
            throw new GenericFileOperationFailedException("Failed to write file " + file, (Throwable)e);
        }
        finally {
            if (this.channel != null) {
                LOG.trace("Disconnecting 'exec' scp channel");
                this.channel.disconnect();
                this.channel = null;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Channel disconnected from {}", (Object)cfg.remoteServerInformation());
                }
            }
        }
        return true;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return this.endpoint.getConfiguration().getDirectory();
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'cd " + path + "' not supported by the scp: protocol");
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'cd ..' not supported by the scp: protocol");
    }

    public ScpFile[] listFiles() throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'ls' not supported by the scp: protocol");
    }

    public ScpFile[] listFiles(String path) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'ls " + path + "' not supported by the scp: protocol");
    }

    public boolean connect(RemoteFileConfiguration configuration, Exchange exchange) throws GenericFileOperationFailedException {
        if (!this.isConnected()) {
            this.session = this.createSession(configuration instanceof ScpConfiguration ? (ScpConfiguration)configuration : null);
            if (!this.isConnected()) {
                this.session = null;
                throw new GenericFileOperationFailedException("Failed to connect to " + configuration.remoteServerInformation());
            }
        }
        return true;
    }

    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected();
    }

    public void disconnect() throws GenericFileOperationFailedException {
        try {
            if (this.isConnected()) {
                this.session.disconnect();
            }
        }
        finally {
            this.session = null;
        }
    }

    public void forceDisconnect() throws GenericFileOperationFailedException {
        try {
            this.session.disconnect();
        }
        finally {
            this.session = null;
        }
    }

    public boolean sendNoop() throws GenericFileOperationFailedException {
        return true;
    }

    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    private Session createSession(ScpConfiguration config) {
        ObjectHelper.notNull((Object)((Object)config), (String)"ScpConfiguration");
        try {
            Object knownHostsFile;
            JSch jsch;
            block28: {
                String pkfp;
                jsch = new JSch();
                if (ObjectHelper.isNotEmpty((String)config.getCiphers())) {
                    LOG.trace("Using ciphers: {}", (Object)config.getCiphers());
                    Hashtable<String, String> ciphers = new Hashtable<String, String>();
                    ciphers.put("cipher.s2c", config.getCiphers());
                    ciphers.put("cipher.c2s", config.getCiphers());
                    JSch.setConfig(ciphers);
                }
                if (ObjectHelper.isNotEmpty((String)config.getPrivateKeyFile())) {
                    LOG.trace("Using private keyfile: {}", (Object)config.getPrivateKeyFile());
                    pkfp = config.getPrivateKeyFilePassphrase();
                    Object name = config.getPrivateKeyFile();
                    if (!((String)name).startsWith("classpath:")) {
                        name = "file:" + (String)name;
                    }
                    try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)name);){
                        byte[] data = (byte[])this.endpoint.getCamelContext().getTypeConverter().mandatoryConvertTo(byte[].class, (Object)is);
                        jsch.addIdentity("camel-jsch", data, null, pkfp != null ? pkfp.getBytes() : null);
                        break block28;
                    }
                    catch (Exception e) {
                        throw new GenericFileOperationFailedException("Cannot load private keyfile: " + config.getPrivateKeyFile(), (Throwable)e);
                    }
                }
                if (ObjectHelper.isNotEmpty((Object)config.getPrivateKeyBytes())) {
                    LOG.trace("Using private key bytes: {}", (Object)config.getPrivateKeyBytes());
                    pkfp = config.getPrivateKeyFilePassphrase();
                    byte[] data = config.getPrivateKeyBytes();
                    try {
                        jsch.addIdentity("camel-jsch", data, null, pkfp != null ? pkfp.getBytes() : null);
                    }
                    catch (Exception e) {
                        throw new GenericFileOperationFailedException("Cannot load private key bytes: " + Arrays.toString(config.getPrivateKeyBytes()), (Throwable)e);
                    }
                }
            }
            if ((knownHostsFile = config.getKnownHostsFile()) == null && config.isUseUserKnownHostsFile()) {
                if (this.userKnownHostFile == null) {
                    this.userKnownHostFile = System.getProperty("user.home") + "/.ssh/known_hosts";
                    LOG.info("Known host file not configured, using user known host file: {}", (Object)this.userKnownHostFile);
                }
                knownHostsFile = this.userKnownHostFile;
            }
            if (ObjectHelper.isNotEmpty((String)knownHostsFile)) {
                if (!((String)knownHostsFile).startsWith("classpath:")) {
                    knownHostsFile = "file:" + (String)knownHostsFile;
                }
                try {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)knownHostsFile);
                    jsch.setKnownHosts(is);
                }
                catch (Exception e) {
                    throw new GenericFileOperationFailedException("Cannot load known host file: " + (String)knownHostsFile, (Throwable)e);
                }
            } else {
                jsch.setKnownHosts((String)null);
            }
            this.session = jsch.getSession(config.getUsername(), config.getHost(), config.getPort());
            this.session.setTimeout(config.getTimeout());
            this.session.setUserInfo((UserInfo)new SessionUserInfo(config));
            if (ObjectHelper.isNotEmpty((String)config.getStrictHostKeyChecking())) {
                LOG.trace("Using StrickHostKeyChecking: {}", (Object)config.getStrictHostKeyChecking());
                this.session.setConfig("StrictHostKeyChecking", config.getStrictHostKeyChecking());
            }
            if (ObjectHelper.isNotEmpty((String)config.getPreferredAuthentications())) {
                LOG.trace("Using preferredAuthentications: {}", (Object)config.getPreferredAuthentications());
                this.session.setConfig("PreferredAuthentications", config.getPreferredAuthentications());
            }
            int timeout = config.getConnectTimeout();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting to {} with {} timeout...", (Object)config.remoteServerInformation(), timeout > 0 ? timeout + " ms" : "no");
            }
            if (timeout > 0) {
                this.session.connect(timeout);
            } else {
                this.session.connect();
            }
        }
        catch (JSchException e) {
            this.session = null;
            LOG.warn("Could not create ssh session for {}", (Object)config.remoteServerInformation(), (Object)e);
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ChannelExec c, String name, InputStream data, ScpConfiguration cfg) throws IOException {
        OutputStream os = c.getOutputStream();
        InputStream is = c.getInputStream();
        try {
            this.writeFile(name, data, os, is, cfg);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, os});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, os});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String filename, InputStream data, OutputStream os, InputStream is, ScpConfiguration cfg) throws IOException {
        int lineFeed = 10;
        int pos = filename.indexOf(47);
        if (pos >= 0) {
            String dir = filename.substring(0, pos);
            Object bytes = "D0775 0 " + dir;
            LOG.trace("[scp:sink] {}", bytes);
            os.write(((String)bytes).getBytes());
            os.write(10);
            os.flush();
            this.readAck(is);
            this.writeFile(filename.substring(pos + 1), data, os, is, cfg);
            bytes = "E";
            LOG.trace("[scp:sink] {}", bytes);
            os.write(((String)bytes).getBytes());
            os.write(10);
            os.flush();
            this.readAck(is);
        } else {
            int count = 0;
            int size = this.endpoint.getBufferSize();
            byte[] reply = new byte[size];
            BufferedInputStream buffer = new BufferedInputStream(data, size);
            try {
                int read;
                buffer.mark(Integer.MAX_VALUE);
                while ((read = buffer.read(reply)) != -1) {
                    count += read;
                }
                String bytes = "C0" + cfg.getChmod() + " " + count + " " + filename;
                LOG.trace("[scp:sink] {}", (Object)bytes);
                os.write(bytes.getBytes());
                os.write(10);
                os.flush();
                this.readAck(is);
                buffer.reset();
                while ((read = buffer.read(reply)) != -1) {
                    os.write(reply, 0, read);
                }
                this.writeAck(os);
                this.readAck(is);
            }
            finally {
                IOHelper.close((Closeable)buffer);
            }
        }
    }

    private void writeAck(OutputStream os) throws IOException {
        os.write(0);
        os.flush();
    }

    private int readAck(InputStream is) throws IOException {
        int answer = is.read();
        switch (answer) {
            case 0: {
                break;
            }
            default: {
                String message = "[scp] Return Code [" + answer + "] " + this.readLine(is);
                throw new IOException(message);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(InputStream is) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int c;
            do {
                if ((c = is.read()) == 10) {
                    String string = bytes.toString();
                    return string;
                }
                bytes.write(c);
            } while (c != -1);
        }
        finally {
            IOHelper.close((Closeable)bytes);
        }
        String message = "[scp] Unexpected end of stream";
        throw new IOException(message);
    }

    private static String getRemoteTarget(ScpConfiguration config) {
        return config.getDirectory().isEmpty() ? "." : config.getDirectory();
    }

    private static String getRemoteFile(String name, ScpConfiguration config) {
        Object dir = config.getDirectory();
        dir = ((String)dir).endsWith("/") ? dir : (String)dir + "/";
        return name.startsWith((String)dir) ? name.substring(((String)dir).length()) : name;
    }

    private static boolean isRecursiveScp(String name) {
        return name.indexOf(47) > 0;
    }

    private static String getScpCommand(ScpConfiguration config, String name) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("scp ");
        cmd.append(ScpOperations.isRecursiveScp(name) ? "-r " : "");
        cmd.append("-t ");
        cmd.append(ScpOperations.getRemoteTarget(config));
        return cmd.toString();
    }

    protected static final class SessionUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final ScpConfiguration config;

        public SessionUserInfo(ScpConfiguration config) {
            ObjectHelper.notNull((Object)((Object)config), (String)"config");
            this.config = config;
        }

        public String getPassphrase() {
            LOG.warn("Private Key authentication not supported");
            return null;
        }

        public String getPassword() {
            LOG.debug("Providing password for ssh authentication of user '{}'", (Object)this.config.getUsername());
            return this.config.getPassword();
        }

        public boolean promptPassword(String message) {
            LOG.debug(message);
            return true;
        }

        public boolean promptPassphrase(String message) {
            LOG.debug(message);
            return true;
        }

        public boolean promptYesNo(String message) {
            LOG.debug(message);
            return false;
        }

        public void showMessage(String message) {
            LOG.debug(message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            LOG.debug(instruction);
            return null;
        }
    }
}

