/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.jsch.ScpConfiguration;
import org.apache.camel.component.jsch.ScpEndpoint;
import org.apache.camel.component.jsch.ScpFile;
import org.slf4j.LoggerFactory;

public class JschComponent
extends RemoteFileComponent<ScpFile> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(JschComponent.class);

    public JschComponent() {
    }

    public JschComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<ScpFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int query = uri.indexOf("?");
        return new ScpEndpoint(uri, this, new ScpConfiguration(new URI(query >= 0 ? uri.substring(0, query) : uri)));
    }

    protected void afterPropertiesSet(GenericFileEndpoint<ScpFile> endpoint) throws Exception {
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    static {
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"yes");
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int level) {
                return level == 4 || level == 3 ? LOG.isErrorEnabled() : (level == 2 ? LOG.isWarnEnabled() : (level == 1 ? LOG.isInfoEnabled() : LOG.isDebugEnabled()));
            }

            public void log(int level, String message) {
                if (level == 4 || level == 3) {
                    LOG.error("[JSCH] {}", (Object)message);
                } else if (level == 2) {
                    LOG.warn("[JSCH] {}", (Object)message);
                } else if (level == 1) {
                    LOG.info("[JSCH] {}", (Object)message);
                } else {
                    LOG.debug("[JSCH] {}", (Object)message);
                }
            }
        });
    }
}

