/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JpaEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":entityType";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "jpa".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "entityType", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(49);
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("consumeDelete");
        props.add("consumeLockEntity");
        props.add("delay");
        props.add("deleteHandler");
        props.add("entityManagerFactory");
        props.add("entityManagerProperties");
        props.add("entityType");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("findEntity");
        props.add("firstResult");
        props.add("flushOnSend");
        props.add("greedy");
        props.add("initialDelay");
        props.add("joinTransaction");
        props.add("lazyStartProducer");
        props.add("lockModeType");
        props.add("maxMessagesPerPoll");
        props.add("maximumResults");
        props.add("namedQuery");
        props.add("nativeQuery");
        props.add("outputTarget");
        props.add("parameters");
        props.add("persistenceUnit");
        props.add("pollStrategy");
        props.add("preDeleteHandler");
        props.add("query");
        props.add("remove");
        props.add("repeatCount");
        props.add("resultClass");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("sharedEntityManager");
        props.add("singleResult");
        props.add("skipLockedEntity");
        props.add("startScheduler");
        props.add("timeUnit");
        props.add("transacted");
        props.add("useExecuteUpdate");
        props.add("useFixedDelay");
        props.add("usePassedInEntityManager");
        props.add("usePersist");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashMap<String, String> prefixes = new HashMap<String, String>(3);
        prefixes.put("entityManagerProperties", "emf.");
        prefixes.put("parameters", "parameters.");
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

