/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jhc.JhcComponent;
import org.apache.camel.component.jhc.JhcConsumer;
import org.apache.camel.component.jhc.JhcHeaderFilterStrategy;
import org.apache.camel.component.jhc.JhcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.http.params.HttpParams;

public class JhcEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private HttpParams params;
    private URI httpUri;
    private HeaderFilterStrategy headerFilterStrategy = new JhcHeaderFilterStrategy();

    public JhcEndpoint(String endpointUri, JhcComponent component, URI httpUri) {
        super(endpointUri, (Component)component);
        this.params = component.getParams().copy();
        this.httpUri = httpUri;
    }

    public JhcEndpoint(String endpointUri, URI httpUri, HttpParams params) {
        super(endpointUri);
        this.httpUri = httpUri;
        this.params = params;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public String getHost() {
        return this.httpUri.getHost();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getPath() {
        return this.httpUri.getPath();
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        return new JhcProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new JhcConsumer(this, processor);
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }
}

