/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jhc.AsyncHttpRequestHandler;
import org.apache.camel.component.jhc.AsyncResponseHandler;
import org.apache.camel.component.jhc.JhcEndpoint;
import org.apache.camel.component.jhc.JhcServerEngine;
import org.apache.camel.component.jhc.JhcServerEngineFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class JhcConsumer
extends DefaultConsumer {
    private static final Log LOG = LogFactory.getLog(JhcConsumer.class);
    private JhcServerEngine engine;
    private MyHandler handler;

    public JhcConsumer(JhcEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.engine = JhcServerEngineFactory.getJhcServerEngine(endpoint.getParams(), endpoint.getPort(), endpoint.getProtocol());
        this.handler = new MyHandler(endpoint.getParams(), endpoint.getPath());
    }

    public JhcEndpoint getEndpoint() {
        return (JhcEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.engine.register(this.handler.getPath() + "*", this.handler);
        if (!this.engine.isStarted()) {
            this.engine.start();
        }
    }

    protected void doStop() throws Exception {
        this.engine.unregister(this.handler.getPath() + "*");
        if (this.engine.getReferenceCounter() == 0) {
            this.engine.stop();
        }
        super.doStop();
    }

    class MyHandler
    implements AsyncHttpRequestHandler {
        private final HttpParams params;
        private final HttpResponseFactory responseFactory;
        private final String path;

        public MyHandler(HttpParams params, String path) {
            this(params, path, (HttpResponseFactory)new DefaultHttpResponseFactory());
        }

        public MyHandler(HttpParams params, String path, HttpResponseFactory responseFactory) {
            this.params = params;
            this.path = path;
            this.responseFactory = responseFactory;
        }

        public String getPath() {
            return this.path;
        }

        public void handle(final HttpRequest request, final HttpContext context, final AsyncResponseHandler handler) throws HttpException, IOException {
            final Exchange exchange = JhcConsumer.this.getEndpoint().createExchange();
            exchange.getIn().setHeader("http.uri", (Object)request.getRequestLine().getUri());
            if (request instanceof HttpEntityEnclosingRequest) {
                exchange.getIn().setBody((Object)((HttpEntityEnclosingRequest)request).getEntity());
            }
            JhcConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSynchronously) {
                    LOG.debug((Object)"handleExchange");
                    HttpVersion httpVersion = (HttpVersion)request.getRequestLine().getProtocolVersion();
                    HttpResponse response = MyHandler.this.responseFactory.newHttpResponse((ProtocolVersion)httpVersion, 200, context);
                    response.setParams(MyHandler.this.params);
                    HttpEntity entity = (HttpEntity)exchange.getOut().getBody(HttpEntity.class);
                    response.setEntity(entity);
                    response.setParams(JhcConsumer.this.getEndpoint().getParams());
                    try {
                        handler.sendResponse(response);
                    }
                    catch (Exception e) {
                        LOG.info((Object)e);
                    }
                }
            });
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        }
    }

    static class EventLogger
    implements EventListener {
        EventLogger() {
        }

        public void connectionOpen(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection open: " + conn));
            }
        }

        public void connectionTimeout(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection timed out: " + conn));
            }
        }

        public void connectionClosed(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection closed: " + conn));
            }
        }

        public void fatalIOException(IOException ex, NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("I/O error: " + ex.getMessage()));
            }
        }

        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HTTP error: " + ex.getMessage()));
            }
        }
    }

    class MyHttpRequestHandler
    implements HttpRequestHandler {
        MyHttpRequestHandler() {
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            LOG.debug((Object)"handle");
        }
    }
}

