/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jhc.JhcEndpoint;
import org.apache.camel.component.jhc.JhcExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JhcProducer
extends DefaultProducer<JhcExchange>
implements AsyncProcessor {
    public static final String HTTP_RESPONSE_CODE = "http.responseCode";
    public static final Set<String> HEADERS_TO_SKIP = new HashSet<String>(Arrays.asList("content-length", "content-type", "http.responseCode".toLowerCase()));
    private static final transient Log LOG = LogFactory.getLog(JhcProducer.class);
    private int nbThreads = 2;
    private ConnectingIOReactor ioReactor;
    private ThreadFactory threadFactory;
    private Thread runner;

    public JhcProducer(JhcEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public JhcEndpoint getEndpoint() {
        return (JhcEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        HttpParams params = this.getEndpoint().getParams();
        this.ioReactor = new DefaultConnectingIOReactor(this.nbThreads, this.threadFactory, params);
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        BufferingHttpClientHandler handler = new BufferingHttpClientHandler((HttpProcessor)httpproc, (HttpRequestExecutionHandler)new MyHttpRequestExecutionHandler(), (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), params);
        handler.setEventListener((EventListener)new EventLogger());
        DefaultClientIOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch((NHttpClientHandler)handler, params);
        this.runner = new Thread(new Runnable((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            public void run() {
                try {
                    JhcProducer.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    LOG.info((Object)"Interrupted");
                }
                catch (IOException e) {
                    LOG.warn((Object)("I/O error: " + e.getMessage()));
                }
                LOG.debug((Object)"Shutdown");
            }
        });
        this.runner.start();
    }

    protected void doStop() throws Exception {
        this.ioReactor.shutdown();
        this.runner.join();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("process: " + exchange));
        }
        AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processAsync: " + exchange));
        }
        InetSocketAddress addr = new InetSocketAddress(this.getEndpoint().getHost(), this.getEndpoint().getPort());
        exchange.setProperty(AsyncCallback.class.getName(), (Object)callback);
        SessionRequest req = this.ioReactor.connect((SocketAddress)addr, null, (Object)exchange, (SessionRequestCallback)new MySessionRequestCallback());
        return false;
    }

    protected HttpRequest createRequest(Exchange exchange) {
        BasicHttpRequest req;
        String uri = this.getEndpoint().getEndpointUri();
        HttpEntity entity = this.createEntity(exchange);
        if (entity == null) {
            req = new BasicHttpRequest("GET", this.getEndpoint().getPath());
        } else {
            req = new BasicHttpEntityEnclosingRequest("POST", this.getEndpoint().getPath());
            ((BasicHttpEntityEnclosingRequest)req).setEntity(entity);
        }
        for (String headerName : exchange.getIn().getHeaders().keySet()) {
            String headerValue;
            if (!this.shouldHeaderBePropagated(headerName, headerValue = (String)exchange.getIn().getHeader(headerName, String.class))) continue;
            req.addHeader(headerName, headerValue);
        }
        return req;
    }

    protected HttpEntity createEntity(Exchange exchange) {
        Message in = exchange.getIn();
        HttpEntity entity = (HttpEntity)in.getBody(HttpEntity.class);
        if (entity == null) {
            String contentEncoding;
            byte[] data = (byte[])in.getBody(byte[].class);
            if (data == null) {
                return null;
            }
            entity = new ByteArrayEntity(data);
            String contentType = (String)in.getHeader("Content-Type", String.class);
            if (contentType != null) {
                ((ByteArrayEntity)entity).setContentType(contentType);
            }
            if ((contentEncoding = (String)in.getHeader("Content-Encoding", String.class)) != null) {
                ((ByteArrayEntity)entity).setContentEncoding(contentEncoding);
            }
        }
        return entity;
    }

    protected boolean shouldHeaderBePropagated(String headerName, String headerValue) {
        if (headerValue == null) {
            return false;
        }
        if (headerName.startsWith("org.apache.camel")) {
            return false;
        }
        return !HEADERS_TO_SKIP.contains(headerName.toLowerCase());
    }

    static class EventLogger
    implements EventListener {
        EventLogger() {
        }

        public void connectionOpen(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection open: " + conn));
            }
        }

        public void connectionTimeout(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection timed out: " + conn));
            }
        }

        public void connectionClosed(NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connection closed: " + conn));
            }
        }

        public void fatalIOException(IOException ex, NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("I/O error: " + ex.getMessage()));
            }
        }

        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HTTP error: " + ex.getMessage()));
            }
        }
    }

    class MyHttpRequestExecutionHandler
    implements HttpRequestExecutionHandler {
        private static final String REQUEST_SENT = "request-sent";
        private static final String RESPONSE_RECEIVED = "response-received";

        MyHttpRequestExecutionHandler() {
        }

        public void initalizeContext(HttpContext httpContext, Object o) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initialize context");
            }
            httpContext.setAttribute(Exchange.class.getName(), (Object)((Exchange)o));
        }

        public HttpRequest submitRequest(HttpContext httpContext) {
            Object flag;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Submit request: " + httpContext));
            }
            if ((flag = httpContext.getAttribute(REQUEST_SENT)) == null) {
                httpContext.setAttribute(REQUEST_SENT, (Object)Boolean.TRUE);
                Exchange e = (Exchange)httpContext.getAttribute(Exchange.class.getName());
                return JhcProducer.this.createRequest(e);
            }
            return null;
        }

        public void handleResponse(HttpResponse httpResponse, HttpContext httpContext) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Handle response");
            }
            httpContext.setAttribute(RESPONSE_RECEIVED, (Object)Boolean.TRUE);
            Exchange e = (Exchange)httpContext.getAttribute(Exchange.class.getName());
            e.getOut().setBody((Object)httpResponse.getEntity());
            HeaderIterator it = httpResponse.headerIterator();
            while (it.hasNext()) {
                Header h = (Header)it.next();
                e.getOut().setHeader(h.getName(), (Object)h.getValue());
            }
            e.getOut().setHeader(JhcProducer.HTTP_RESPONSE_CODE, (Object)httpResponse.getStatusLine().getStatusCode());
            AsyncCallback callback = (AsyncCallback)e.removeProperty(AsyncCallback.class.getName());
            callback.done(false);
        }

        public void finalizeContext(HttpContext httpContext) {
        }
    }

    static class MySessionRequestCallback
    implements SessionRequestCallback {
        MySessionRequestCallback() {
        }

        public void completed(SessionRequest sessionRequest) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Completed");
            }
        }

        public void failed(SessionRequest sessionRequest) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed");
            }
        }

        public void timeout(SessionRequest sessionRequest) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Timeout");
            }
        }

        public void cancelled(SessionRequest sessionRequest) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cancelled");
            }
        }
    }
}

