/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import org.apache.camel.component.jhc.AsyncHttpRequestHandler;
import org.apache.camel.component.jhc.AsyncResponseHandler;
import org.apache.camel.component.jhc.BufferingHttpServiceHandler;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpParamsLinker;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class AsyncBufferingHttpServiceHandler
extends BufferingHttpServiceHandler {
    public AsyncBufferingHttpServiceHandler(HttpParams params) {
        super(AsyncBufferingHttpServiceHandler.createDefaultProcessor(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), params);
    }

    public AsyncBufferingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, HttpParams params) {
        super(httpProcessor, responseFactory, connStrategy, params);
    }

    public AsyncBufferingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        super(httpProcessor, responseFactory, connStrategy, allocator, params);
    }

    protected static HttpProcessor createDefaultProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        return httpproc;
    }

    protected void processRequest(final NHttpServerConnection conn, HttpRequest request) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.connection", (Object)conn);
        try {
            HttpResponse response;
            this.httpProcessor.process(request, context);
            HttpRequestHandler handler = null;
            if (this.handlerResolver != null) {
                String requestURI = request.getRequestLine().getUri();
                handler = this.handlerResolver.lookup(requestURI);
            }
            if (handler != null) {
                if (handler instanceof AsyncHttpRequestHandler) {
                    ((AsyncHttpRequestHandler)handler).handle(request, context, new AsyncResponseHandler(){

                        public void sendResponse(HttpResponse response) throws IOException, HttpException {
                            try {
                                AsyncBufferingHttpServiceHandler.this.sendResponse(conn, response);
                            }
                            catch (HttpException ex) {
                                response = AsyncBufferingHttpServiceHandler.this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, conn.getContext());
                                HttpParamsLinker.link((HttpMessage)response, (HttpParams)AsyncBufferingHttpServiceHandler.this.params);
                                AsyncBufferingHttpServiceHandler.this.handleException(ex, response);
                                AsyncBufferingHttpServiceHandler.this.sendResponse(conn, response);
                            }
                        }
                    });
                } else {
                    response = this.responseFactory.newHttpResponse(ver, 200, conn.getContext());
                    HttpParamsLinker.link((HttpMessage)response, (HttpParams)this.params);
                    context.setAttribute("http.response", (Object)response);
                    handler.handle(request, response, context);
                    this.sendResponse(conn, response);
                }
            } else {
                response = this.responseFactory.newHttpResponse(ver, 200, conn.getContext());
                response.setStatusCode(501);
            }
        }
        catch (HttpException ex) {
            HttpResponse response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, context);
            HttpParamsLinker.link((HttpMessage)response, (HttpParams)this.params);
            this.handleException(ex, response);
            this.sendResponse(conn, response);
        }
    }
}

