/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;

public class JGroupsProducer
extends DefaultProducer {
    private final JGroupsEndpoint endpoint;
    private final Channel channel;
    private final String clusterName;

    public JGroupsProducer(JGroupsEndpoint endpoint, Channel channel, String clusterName) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.channel = channel;
        this.clusterName = clusterName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect();
    }

    protected void doStop() throws Exception {
        this.endpoint.disconnect();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            Address destinationAddress = (Address)exchange.getIn().getHeader("JGROUPS_DEST", Address.class);
            Address sourceAddress = (Address)exchange.getIn().getHeader("JGROUPS_SRC", Address.class);
            this.log.debug("Posting: {} to cluster: {}", body, (Object)this.clusterName);
            if (destinationAddress != null) {
                this.log.debug("Posting to custom destination address: {}", (Object)destinationAddress);
            }
            if (sourceAddress != null) {
                this.log.debug("Posting from custom source address: {}", (Object)sourceAddress);
            }
            this.channel.send(new Message(destinationAddress, sourceAddress, body));
        } else {
            this.log.debug("Body is null, cannot post to channel.");
        }
    }
}

