/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft.cluster;

import org.apache.camel.component.jgroups.raft.cluster.JGroupsRaftClusterView;
import org.apache.camel.util.ObjectHelper;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRoleChangeListener
implements RAFT.RoleChange {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleChangeListener.class);
    private final JGroupsRaftClusterView jgroupsRaftClusterView;

    public ClusterRoleChangeListener(JGroupsRaftClusterView jgroupsRaftClusterView) {
        ObjectHelper.notNull((Object)((Object)jgroupsRaftClusterView), (String)"endpoint");
        this.jgroupsRaftClusterView = jgroupsRaftClusterView;
    }

    public void roleChanged(Role role) {
        LOG.debug("Role received {}.", (Object)role);
        switch (role) {
            case Leader: {
                if (this.jgroupsRaftClusterView.isMaster()) break;
                this.jgroupsRaftClusterView.setMaster(true);
                this.jgroupsRaftClusterView.fireLeadershipChangedEvent(this.jgroupsRaftClusterView.getLocalMember());
                break;
            }
            case Follower: {
                if (!this.jgroupsRaftClusterView.isMaster()) break;
                this.jgroupsRaftClusterView.setMaster(false);
                this.jgroupsRaftClusterView.fireLeadershipChangedEvent(null);
                break;
            }
            default: {
                LOG.error("Role {} unknown.", (Object)role);
                throw new UnsupportedOperationException("Role " + String.valueOf(role) + " unknown.");
            }
        }
    }
}

