/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model;

import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Knative;

public final class KnativeBuilder {
    private Boolean auto;
    private List<String> channelSinks;
    private List<String> channelSources;
    private String configuration;
    private Boolean enabled;
    private List<String> endpointSinks;
    private List<String> endpointSources;
    private List<String> eventSinks;
    private List<String> eventSources;
    private Boolean filterEventType;
    private List<String> filters;
    private Boolean sinkBinding;

    private KnativeBuilder() {
    }

    public static KnativeBuilder knative() {
        return new KnativeBuilder();
    }

    public KnativeBuilder withAuto(Boolean auto) {
        this.auto = auto;
        return this;
    }

    public KnativeBuilder withChannelSinks(List<String> channelSinks) {
        this.channelSinks = channelSinks;
        return this;
    }

    public KnativeBuilder withChannelSources(List<String> channelSources) {
        this.channelSources = channelSources;
        return this;
    }

    public KnativeBuilder withConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public KnativeBuilder withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public KnativeBuilder withEndpointSinks(List<String> endpointSinks) {
        this.endpointSinks = endpointSinks;
        return this;
    }

    public KnativeBuilder withEndpointSources(List<String> endpointSources) {
        this.endpointSources = endpointSources;
        return this;
    }

    public KnativeBuilder withEventSinks(List<String> eventSinks) {
        this.eventSinks = eventSinks;
        return this;
    }

    public KnativeBuilder withEventSources(List<String> eventSources) {
        this.eventSources = eventSources;
        return this;
    }

    public KnativeBuilder withFilterEventType(Boolean filterEventType) {
        this.filterEventType = filterEventType;
        return this;
    }

    public KnativeBuilder withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public KnativeBuilder withSinkBinding(Boolean sinkBinding) {
        this.sinkBinding = sinkBinding;
        return this;
    }

    public Knative build() {
        Knative knative = new Knative();
        knative.setAuto(this.auto);
        knative.setChannelSinks(this.channelSinks);
        knative.setChannelSources(this.channelSources);
        knative.setConfiguration(this.configuration);
        knative.setEnabled(this.enabled);
        knative.setEndpointSinks(this.endpointSinks);
        knative.setEndpointSources(this.endpointSources);
        knative.setEventSinks(this.eventSinks);
        knative.setEventSources(this.eventSources);
        knative.setFilterEventType(this.filterEventType);
        knative.setFilters(this.filters);
        knative.setSinkBinding(this.sinkBinding);
        return knative;
    }
}

