/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.traits;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.BaseTrait;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Mount;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class MountTrait
extends BaseTrait {
    private static final Pattern RESOURCE_VALUE_EXPRESSION = Pattern.compile("^([\\w.\\-_:]+)(/([\\w.\\-_:]+))?(@([\\w.\\-_:/]+))?$");
    public static final int MOUNT_TRAIT_ORDER = 1610;

    public MountTrait() {
        super("mount", 1610);
    }

    @Override
    public boolean configure(Traits traitConfig, TraitContext context) {
        Mount mountTrait = Optional.ofNullable(traitConfig.getMount()).orElseGet(Mount::new);
        if (mountTrait.getConfigs() != null) {
            for (String config : mountTrait.getConfigs()) {
                if (config.startsWith("configmap:") || config.startsWith("secret:")) continue;
                throw new RuntimeCamelException("Unsupported config %s, must be a configmap or secret resource".formatted(config));
            }
        }
        if (mountTrait.getResources() != null) {
            for (String resource : mountTrait.getResources()) {
                if (resource.startsWith("configmap:") || resource.startsWith("secret:")) continue;
                throw new RuntimeCamelException("Unsupported resource %s, must be a configmap or secret resource".formatted(resource));
            }
        }
        return true;
    }

    @Override
    public void apply(Traits traitConfig, TraitContext context) {
        Mount mountTrait = Optional.ofNullable(traitConfig.getMount()).orElseGet(Mount::new);
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        this.configureVolumesAndMounts(mountTrait, volumes, volumeMounts);
        Optional<DeploymentBuilder> deployment = context.getDeployment();
        deployment.ifPresent(d -> ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)d.editOrNewSpec().editOrNewTemplate().editOrNewSpec().addAllToVolumes((Collection)volumes)).editFirstContainer().addAllToVolumeMounts((Collection)volumeMounts)).endContainer()).endSpec()).endTemplate()).endSpec());
    }

    private void configureVolumesAndMounts(Mount mountTrait, List<Volume> volumes, List<VolumeMount> volumeMounts) {
        if (mountTrait.getConfigs() != null) {
            for (String c : mountTrait.getConfigs()) {
                this.mountResource(volumes, volumeMounts, this.parseConfig(c, MountResource.ContentType.TEXT));
            }
        }
        if (mountTrait.getResources() != null) {
            for (String r : mountTrait.getResources()) {
                this.mountResource(volumes, volumeMounts, this.parseConfig(r, MountResource.ContentType.DATA));
            }
        }
        if (mountTrait.getVolumes() != null) {
            for (String v : mountTrait.getVolumes()) {
                this.mountResource(volumes, volumeMounts, this.parseConfig(v, null));
            }
        }
    }

    private void mountResource(List<Volume> volumes, List<VolumeMount> volumeMounts, MountResource mountResource) {
        String volumeName = KubernetesHelper.sanitize(mountResource.name);
        String dstDir = Optional.ofNullable(mountResource.destinationPath).orElse("");
        String dstFile = !dstDir.isEmpty() && !mountResource.key.isEmpty() ? FileUtil.onlyName((String)dstDir) : mountResource.key;
        Volume vol = this.getVolume(volumeName, mountResource, dstFile);
        boolean readOnly = mountResource.storageType != MountResource.StorageType.PVC;
        VolumeMount mnt = this.getMount(volumeName, this.getMountPath(mountResource, dstDir), dstFile, readOnly);
        volumes.add(vol);
        volumeMounts.add(mnt);
    }

    private VolumeMount getMount(String volumeName, String mountPath, String subPath, boolean readOnly) {
        VolumeMountBuilder mount = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volumeName)).withMountPath(mountPath)).withReadOnly(Boolean.valueOf(readOnly));
        if (ObjectHelper.isNotEmpty((String)subPath)) {
            mount.withSubPath(subPath);
        }
        return mount.build();
    }

    private Volume getVolume(String volumeName, MountResource mountResource, String mountPath) {
        VolumeBuilder volume = (VolumeBuilder)new VolumeBuilder().withName(volumeName);
        switch (mountResource.storageType.ordinal()) {
            case 0: {
                ConfigMapVolumeSourceBuilder cmVolumeSource = (ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(mountResource.name);
                if (ObjectHelper.isNotEmpty((String)mountResource.key)) {
                    cmVolumeSource.addToItems(new KeyToPath[]{((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(mountResource.key)).withPath(Optional.ofNullable(mountPath).orElse(mountResource.key))).build()});
                }
                ((VolumeBuilder)volume.withConfigMap(cmVolumeSource.build())).build();
                break;
            }
            case 1: {
                SecretVolumeSourceBuilder volumeSource = (SecretVolumeSourceBuilder)new SecretVolumeSourceBuilder().withSecretName(mountResource.name);
                if (ObjectHelper.isNotEmpty((String)mountResource.key)) {
                    volumeSource.addToItems(new KeyToPath[]{((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(mountResource.key)).withPath(Optional.ofNullable(mountPath).orElse(mountResource.key))).build()});
                }
                ((VolumeBuilder)volume.withSecret(volumeSource.build())).build();
                break;
            }
            case 2: {
                volume.withPersistentVolumeClaim(((PersistentVolumeClaimVolumeSourceBuilder)new PersistentVolumeClaimVolumeSourceBuilder().withClaimName(mountResource.name)).build());
            }
        }
        return volume.build();
    }

    private String getMountPath(MountResource mountResource, String mountPoint) {
        if (!mountPoint.isEmpty()) {
            return mountPoint;
        }
        Object baseMountPoint = mountResource.contentType == MountResource.ContentType.DATA ? "/etc/camel/resources.d" : "/etc/camel/conf.d";
        baseMountPoint = mountResource.storageType == MountResource.StorageType.SECRET ? (String)baseMountPoint + "/_secrets" : (String)baseMountPoint + "/_configmaps";
        return Path.of((String)baseMountPoint, mountResource.name).toString();
    }

    private MountResource parseConfig(String expression, MountResource.ContentType contentType) {
        if (expression.startsWith("configmap:")) {
            return this.createConfig(expression.substring("configmap:".length()), MountResource.StorageType.CONFIGMAP, contentType);
        }
        if (expression.startsWith("secret:")) {
            return this.createConfig(expression.substring("secret:".length()), MountResource.StorageType.SECRET, contentType);
        }
        String[] configParts = expression.split(":", 2);
        if (configParts.length != 2) {
            throw new RuntimeCamelException("Unsupported volume configuration '%s', expected format is \"<resourceName>:<destinationPath>\"".formatted(expression));
        }
        return new MountResource(MountResource.StorageType.PVC, null, configParts[0], "", configParts[1]);
    }

    private MountResource createConfig(String expression, MountResource.StorageType storageType, MountResource.ContentType contentType) {
        Matcher resourceCoordinates = RESOURCE_VALUE_EXPRESSION.matcher(expression);
        if (resourceCoordinates.matches()) {
            return new MountResource(storageType, contentType, resourceCoordinates.group(0), resourceCoordinates.group(2), resourceCoordinates.group(4));
        }
        return new MountResource(storageType, contentType, expression, "", "");
    }

    private record MountResource(StorageType storageType, ContentType contentType, String name, String key, String destinationPath) {

        private static enum StorageType {
            CONFIGMAP,
            SECRET,
            PVC;

        }

        private static enum ContentType {
            DATA,
            TEXT;

        }
    }
}

