/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.ExportHelper;
import org.apache.camel.dsl.jbang.core.commands.RunHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.CatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.ClusterType;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitCatalog;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitContext;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.TraitHelper;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Container;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.traits.model.Traits;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.SourceHelper;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export as Maven/Gradle project that contains a Kubernetes deployment manifest"}, sortOptions=false)
public class KubernetesExport
extends Export {
    @CommandLine.Option(names={"--service-account"}, description={"The service account used to run the application."})
    protected String serviceAccount;
    @CommandLine.Option(names={"--config"}, description={"Add a runtime configuration from a ConfigMap or a Secret (syntax: [configmap|secret]:name[/key], where name represents the configmap/secret name and key optionally represents the configmap/secret key to be filtered)."})
    protected String[] configs;
    @CommandLine.Option(names={"--resource"}, description={"Add a runtime resource from a Configmap or a Secret (syntax: [configmap|secret]:name[/key][@path], where name represents the configmap/secret name, key optionally represents the configmap/secret key to be filtered and path represents the destination path)."})
    protected String[] resources;
    @CommandLine.Option(names={"--env"}, description={"Set an environment variable in the integration container, for instance \"-e MY_VAR=my-value\"."})
    protected String[] envVars;
    @CommandLine.Option(names={"--volume"}, description={"Mount a volume into the integration container, for instance \"-v pvcname:/container/path\"."})
    protected String[] volumes;
    @CommandLine.Option(names={"--connect"}, description={"A Service that the integration should bind to, specified as [[apigroup/]version:]kind:[namespace/]name."})
    protected String[] connects;
    @CommandLine.Option(names={"--annotation"}, description={"Add an annotation to the integration. Use name values pairs like \"--annotation my.company=hello\"."})
    protected String[] annotations;
    @CommandLine.Option(names={"--label"}, description={"Add a label to the integration. Use name values pairs like \"--label my.company=hello\"."})
    protected String[] labels;
    @CommandLine.Option(names={"--trait"}, description={"Add a trait configuration to the integration. Use name values pairs like \"--trait trait.name.config=hello\"."})
    protected String[] traits;
    @CommandLine.Option(names={"--image"}, description={"The image name to be built."})
    protected String image;
    @CommandLine.Option(names={"--image-registry"}, description={"The image registry to hold the app container image."})
    protected String imageRegistry;
    @CommandLine.Option(names={"--image-group"}, description={"The image registry group used to push images to."})
    protected String imageGroup;
    @CommandLine.Option(names={"--image-builder"}, defaultValue="jib", description={"The image builder used to build the container image (e.g. docker, jib, podman)."})
    protected String imageBuilder = "jib";
    @CommandLine.Option(names={"--image-push"}, defaultValue="true", description={"Whether to push the container image to a given image registry."})
    protected boolean imagePush = true;
    @CommandLine.Option(names={"--image-platform"}, description={"List of target platforms. Each platform is defined using os and architecture (e.g. linux/amd64)."})
    protected String[] imagePlatforms;
    @CommandLine.Option(names={"--base-image"}, description={"The base image that is used to build the container image from (default is eclipse-temurin:<java-version>)."})
    protected String baseImage;
    @CommandLine.Option(names={"--registry-mirror"}, description={"Optional Docker registry mirror where to pull images from when building the container image."})
    protected String registryMirror;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube or Openshift."})
    protected String clusterType;
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources/";

    public KubernetesExport(CamelJBangMain main) {
        super(main);
    }

    public KubernetesExport(CamelJBangMain main, String[] files) {
        super(main);
        this.files.addAll(Arrays.asList(files));
    }

    public KubernetesExport(CamelJBangMain main, ExportConfigurer configurer) {
        super(main);
        this.runtime = configurer.runtime;
        this.quarkusVersion = configurer.quarkusVersion;
        this.exportBaseDir = configurer.exportBaseDir;
        this.files = configurer.files;
        this.name = configurer.name;
        this.gav = configurer.gav;
        this.repositories = configurer.repositories;
        this.dependencies = configurer.dependencies;
        this.excludes = configurer.excludes;
        this.mavenSettings = configurer.mavenSettings;
        this.mavenSettingsSecurity = configurer.mavenSettingsSecurity;
        this.mavenCentralEnabled = configurer.mavenCentralEnabled;
        this.mavenApacheSnapshotEnabled = configurer.mavenApacheSnapshotEnabled;
        this.javaVersion = configurer.javaVersion;
        this.camelVersion = configurer.camelVersion;
        this.kameletsVersion = configurer.kameletsVersion;
        this.profile = configurer.profile;
        this.localKameletDir = configurer.localKameletDir;
        this.springBootVersion = configurer.springBootVersion;
        this.camelSpringBootVersion = configurer.camelSpringBootVersion;
        this.quarkusGroupId = configurer.quarkusGroupId;
        this.quarkusArtifactId = configurer.quarkusArtifactId;
        this.buildTool = configurer.buildTool;
        this.openapi = configurer.openapi;
        this.exportDir = configurer.exportDir;
        this.packageName = configurer.packageName;
        this.buildProperties = configurer.buildProperties;
        this.symbolicLink = configurer.symbolicLink;
        this.javaLiveReload = configurer.javaLiveReload;
        this.ignoreLoadingError = configurer.ignoreLoadingError;
        this.mavenWrapper = configurer.mavenWrapper;
        this.gradleWrapper = configurer.gradleWrapper;
        this.fresh = configurer.fresh;
        this.download = configurer.download;
        this.skipPlugins = configurer.skipPlugins;
        this.packageScanJars = configurer.packageScanJars;
        this.quiet = configurer.quiet;
        this.logging = configurer.logging;
        this.loggingLevel = configurer.loggingLevel;
        this.verbose = configurer.verbose;
        this.observe = true;
    }

    public Integer export() throws Exception {
        List sources;
        String name;
        Path first;
        if (this.runtime == null) {
            this.runtime = RuntimeType.quarkus;
        }
        if (this.files != null && this.files.size() == 1 && Files.isDirectory(first = Path.of(name = FileUtil.stripTrailingSeparator((String)((String)this.files.get(0))), new String[0]), new LinkOption[0])) {
            this.exportBaseDir = first;
            RunHelper.dirToFiles((String)name, (List)this.files);
        }
        this.printer().println("Exporting application ...");
        if (!this.buildTool.equals("maven")) {
            this.printer().printf("--build-tool=%s is not yet supported%n", new Object[]{this.buildTool});
        }
        String resolvedImageGroup = this.resolveImageGroup();
        String resolvedImageRegistry = this.resolveImageRegistry();
        if (resolvedImageRegistry != null) {
            boolean allowInsecure;
            this.buildProperties.add("jkube.container-image.registry=%s".formatted(resolvedImageRegistry));
            if (this.imagePush) {
                this.buildProperties.add("jkube.docker.push.registry=%s".formatted(resolvedImageRegistry));
            }
            if ((allowInsecure = resolvedImageRegistry.startsWith("localhost")) && "jib".equals(this.imageBuilder)) {
                this.buildProperties.add("jib.allowInsecureRegistries=true");
            }
        }
        String projectName = this.getProjectName();
        String runtimeVersion = this.runtime == RuntimeType.quarkus ? this.quarkusVersion : (this.runtime == RuntimeType.springBoot ? this.camelSpringBootVersion : this.camelVersion);
        CamelCatalog catalog = CatalogHelper.loadCatalog(this.runtime, runtimeVersion, this.download);
        try {
            this.addFile("classpath:templates/run-java.sh");
            sources = SourceHelper.resolveSources((List)this.files);
        }
        catch (Exception e) {
            this.printer().printf("Project export failed: %s - %s%n", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("unknown reason")});
            return 1;
        }
        TraitContext context = new TraitContext(projectName, this.getVersion(), this.printer(), catalog, sources);
        this.annotations = Optional.ofNullable(this.annotations).orElse(new String[0]);
        context.addAnnotations(Arrays.stream(this.annotations).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        this.annotations = Optional.ofNullable(this.annotations).orElse(new String[0]);
        context.addAnnotations(Arrays.stream(this.annotations).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        context.addLabel("app.kubernetes.io/runtime", "camel");
        if (this.labels != null) {
            context.addLabels(Arrays.stream(this.labels).map(item -> item.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1])));
        }
        if (this.clusterType != null) {
            context.setClusterType(ClusterType.valueOf(this.clusterType.toUpperCase()));
        }
        if (this.serviceAccount != null) {
            context.setServiceAccount(this.serviceAccount);
        }
        String[] applicationProfileProperties = new String[]{};
        if (this.profile != null) {
            applicationProfileProperties = this.extractPropertiesTraits(this.exportBaseDir.resolve("application-" + this.profile + ".properties"));
        }
        Traits traitsSpec = this.getTraitSpec(applicationProfileProperties, this.applicationProperties);
        Map propsMap = this.propertiesMap(new String[][]{applicationProfileProperties, this.applicationProperties});
        if (propsMap.containsKey("ssl.truststore.certificates")) {
            this.addEnvVar("SSL_TRUSTSTORE_CERTIFICATES", (String)propsMap.get("ssl.truststore.certificates"));
        }
        TraitHelper.configureMountTrait(traitsSpec, this.configs, this.resources, this.volumes);
        if (this.openapi != null && this.openapi.startsWith("configmap:")) {
            TraitHelper.configureOpenApiSpec(traitsSpec, this.openapi);
            this.openapi = null;
        }
        TraitHelper.configureContainerImage(traitsSpec, this.image, resolvedImageRegistry, resolvedImageGroup, projectName, this.getVersion(), this.buildProperties);
        TraitHelper.configureEnvVars(traitsSpec, this.envVars);
        TraitHelper.configureConnects(traitsSpec, this.connects);
        Container container = traitsSpec.getContainer();
        if (container.getName() != null && !container.getName().equals(projectName)) {
            this.printer().printf("Custom container name '%s' not supported%n".formatted(container.getName()), new Object[0]);
        }
        this.buildProperties.add("jkube.skip.push=%b".formatted(!this.imagePush));
        if (ClusterType.OPENSHIFT.isEqualTo(this.clusterType)) {
            context.addLabel("app.openshift.io/runtime", "camel");
            if (!"docker".equals(this.imageBuilder)) {
                this.printer().printf("OpenShift forcing --image-builder=docker%n", new Object[0]);
                this.imageBuilder = "docker";
            }
            this.buildProperties.add("jkube.build.switchToDeployment=true");
            this.buildProperties.add("jkube.maven.plugin=%s".formatted("openshift-maven-plugin"));
        } else {
            this.buildProperties.add("jkube.maven.plugin=%s".formatted("kubernetes-maven-plugin"));
        }
        if (this.baseImage == null) {
            this.baseImage = "eclipse-temurin:%s".formatted(this.javaVersion);
        }
        if (this.registryMirror != null) {
            this.baseImage = "%s/%s".formatted(this.registryMirror, this.baseImage);
        }
        this.buildProperties.add("jkube.container-image.from=%s".formatted(this.baseImage));
        this.buildProperties.add("jkube.build.strategy=%s".formatted(this.imageBuilder));
        if ("jib".equals(this.imageBuilder)) {
            this.buildProperties.add("jkube.container-image.nocache=true");
            this.buildProperties.add("jib.disableUpdateChecks=true");
        }
        if (this.imagePlatforms != null) {
            this.buildProperties.add("jkube.container-image.platforms=%s".formatted(Arrays.stream(this.imagePlatforms).distinct().collect(Collectors.joining(","))));
        }
        if (this.runtime == RuntimeType.main) {
            this.addDependencies(new String[]{"org.apache.camel:camel-health", "org.apache.camel:camel-platform-http-main"});
        }
        Path settingsPath = CommandLineHelper.getWorkDir().resolve("camel-jbang-run.properties");
        String jkubeVersion = KubernetesExport.jkubeMavenPluginVersion((Path)settingsPath, (Properties)this.mapBuildProperties());
        int managementPort = KubernetesExport.httpManagementPort((Path)settingsPath);
        this.buildProperties.add("jkube.version=%s".formatted(jkubeVersion));
        this.setContainerHealthPaths(managementPort);
        int exit = super.doExport();
        if (exit != 0) {
            this.printer().println("Project export failed");
            return exit;
        }
        this.printer().println("Building Kubernetes manifest ...");
        new TraitCatalog().apply(traitsSpec, context, this.clusterType, this.runtime);
        List<Map> kubeFragments = context.buildItems().stream().map(KubernetesHelper::toJsonMap).toList();
        for (Map map : kubeFragments) {
            String ymlFragment = KubernetesHelper.dumpYaml(map);
            String kind = map.get("kind").toString().toLowerCase();
            ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(ymlFragment.getBytes(StandardCharsets.UTF_8)), (Path)Paths.get(this.exportDir, "src/main/jkube", kind + ".yml"));
        }
        context.doWithConfigurationResources((fileName, content) -> {
            try {
                Path targetPath = Paths.get(this.exportDir, "src/main/resources", fileName);
                if (Files.exists(targetPath, new LinkOption[0])) {
                    Files.writeString(targetPath, (CharSequence)"%n%s".formatted(content), StandardOpenOption.APPEND);
                } else {
                    ExportHelper.safeCopy((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (Path)targetPath);
                }
            }
            catch (Exception e) {
                this.printer().printf("Failed to create configuration resource %s - %s%n", new Object[]{this.exportDir + SRC_MAIN_RESOURCES + fileName, e.getMessage()});
            }
        });
        this.printer().println("Project export successful!");
        return 0;
    }

    protected Integer export(Path exportBaseDir, ExportBaseCommand cmd) throws Exception {
        if (this.runtime == RuntimeType.quarkus) {
            cmd.pomTemplateName = "quarkus-kubernetes-pom.tmpl";
        }
        if (this.runtime == RuntimeType.springBoot) {
            cmd.pomTemplateName = "spring-boot-kubernetes-pom.tmpl";
        }
        if (this.runtime == RuntimeType.main) {
            cmd.pomTemplateName = "main-kubernetes-pom.tmpl";
        }
        return super.export(exportBaseDir, cmd);
    }

    protected Traits getTraitSpec(String[] applicationProfileProperties, String[] applicationProperties) {
        String[] annotationsTraits = TraitHelper.extractTraitsFromAnnotations(this.annotations);
        String[] allTraits = TraitHelper.mergeTraits(this.traits, annotationsTraits, applicationProfileProperties, applicationProperties);
        Traits traitsSpec = allTraits.length > 0 ? TraitHelper.parseTraits(allTraits) : new Traits();
        return traitsSpec;
    }

    private void addFile(String file) {
        if (!this.files.contains(file)) {
            this.files = new ArrayList(this.files);
            this.files.add(file);
        }
    }

    private void addEnvVar(String key, String value) {
        String[] envArray = Optional.ofNullable(this.envVars).orElse(new String[0]);
        ArrayList<String> envList = new ArrayList<String>(Arrays.asList(envArray));
        String envEntry = "%s=%s".formatted(key, value);
        if (!envList.contains(envEntry)) {
            envList.add(envEntry);
            this.envVars = envList.toArray(new String[0]);
        }
    }

    private String resolveImageGroup() {
        if (this.image != null) {
            return this.extractImageGroup(this.image);
        }
        if (this.imageGroup != null) {
            return this.imageGroup;
        }
        if (this.gav != null) {
            String groupId = this.parseMavenGav(this.gav).getGroupId();
            String[] dotToks = groupId.split("\\.");
            return dotToks[dotToks.length - 1];
        }
        return null;
    }

    private String resolveImageRegistry() {
        String extracted;
        if (this.image != null && (extracted = this.extractImageRegistry(this.image)) != null) {
            return extracted;
        }
        if (this.imageRegistry != null) {
            if (this.imageRegistry.equals("kind") || this.imageRegistry.equals("kind-registry")) {
                return "localhost:5001";
            }
            if (this.imageRegistry.equals("minikube") || this.imageRegistry.equals("minikube-registry")) {
                return "localhost:5000";
            }
            return this.imageRegistry;
        }
        if (ClusterType.KIND.isEqualTo(this.clusterType)) {
            return "localhost:5001";
        }
        if (ClusterType.MINIKUBE.isEqualTo(this.clusterType)) {
            return "localhost:5000";
        }
        return null;
    }

    private void setContainerHealthPaths(int port) {
        Object probePort;
        Object object = probePort = port > 0 ? "" + port : "9876";
        if (RuntimeType.quarkus == this.runtime) {
            this.buildProperties.add("jkube.enricher.jkube-healthcheck-quarkus.port=" + (String)probePort);
            this.buildProperties.add("quarkus.smallrye-health.root-path=/observe/health");
            ArrayList<Object> newProps = new ArrayList<Object>();
            newProps.add("quarkus.management.port=" + (String)probePort);
            if (this.applicationProperties == null) {
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            } else {
                newProps.addAll(Arrays.asList(this.applicationProperties));
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            }
        } else if (RuntimeType.springBoot == this.runtime) {
            ArrayList<Object> newProps = new ArrayList<Object>();
            newProps.add("management.endpoints.web.base-path=/observe");
            newProps.add("management.server.port=" + (String)probePort);
            newProps.add("management.health.probes.enabled=true");
            if (this.applicationProperties == null) {
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            } else {
                newProps.addAll(Arrays.asList(this.applicationProperties));
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            }
        } else if (RuntimeType.main == this.runtime) {
            ArrayList<Object> newProps = new ArrayList<Object>();
            newProps.add("camel.management.port=" + (String)probePort);
            if (this.applicationProperties == null) {
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            } else {
                newProps.addAll(Arrays.asList(this.applicationProperties));
                this.applicationProperties = newProps.toArray(new String[newProps.size()]);
            }
        }
    }

    private String extractImageGroup(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[1];
        }
        if (parts.length > 1) {
            return parts[0];
        }
        return this.imageGroup;
    }

    private String extractImageRegistry(String image) {
        String[] parts = image.split("/");
        if (parts.length == 3) {
            return parts[0];
        }
        return this.imageRegistry;
    }

    protected String[] extractPropertiesTraits(Path path) throws Exception {
        if (Files.exists(path, new LinkOption[0])) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, (Path)path);
            return TraitHelper.extractTraitsFromProperties((Properties)prop);
        }
        return null;
    }

    protected String[] extractPropertiesTraits(File file) throws Exception {
        return this.extractPropertiesTraits(file.toPath());
    }

    protected String getProjectName() {
        if (this.name != null) {
            return KubernetesHelper.sanitize(this.name);
        }
        if (this.image != null) {
            return KubernetesHelper.sanitize(StringHelper.beforeLast((String)this.image, (String)":"));
        }
        return KubernetesHelper.sanitize(super.getProjectName());
    }

    protected String getVersion() {
        if (this.image != null) {
            return StringHelper.afterLast((String)this.image, (String)":");
        }
        return super.getVersion();
    }

    protected void setApplicationProperties(String[] props) {
        this.applicationProperties = props;
    }

    public record ExportConfigurer(RuntimeType runtime, Path exportBaseDir, String quarkusVersion, List<String> files, String name, String gav, String repositories, List<String> dependencies, List<String> excludes, String mavenSettings, String mavenSettingsSecurity, boolean mavenCentralEnabled, boolean mavenApacheSnapshotEnabled, String javaVersion, String camelVersion, String kameletsVersion, String profile, String localKameletDir, String springBootVersion, String camelSpringBootVersion, String quarkusGroupId, String quarkusArtifactId, String buildTool, String openapi, String exportDir, String packageName, List<String> buildProperties, boolean symbolicLink, boolean javaLiveReload, boolean ignoreLoadingError, boolean mavenWrapper, boolean gradleWrapper, boolean fresh, boolean download, boolean packageScanJars, boolean quiet, boolean logging, String loggingLevel, boolean verbose, boolean skipPlugins) {
    }
}

