/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.dsl.jbang.core.common.Printer;

public class StringPrinter
implements Printer {
    private final StringWriter writer = new StringWriter();

    @Override
    public void println() {
        this.writer.write(System.lineSeparator());
    }

    @Override
    public void println(String line) {
        this.printf("%s%n", line);
    }

    @Override
    public void print(String output) {
        this.writer.write(output);
    }

    @Override
    public void printf(String format, Object ... args) {
        this.writer.write(format.formatted(args));
    }

    public String getOutput() {
        return this.writer.toString().trim();
    }

    public List<String> getLines() throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(new StringReader(this.getOutput()));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = buf.readLine()) != null) {
            lines.add(line.trim());
        }
        return lines;
    }
}

