/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.util.Locale;
import org.apache.camel.catalog.DefaultCamelCatalog;

public enum RuntimeType {
    springBoot,
    quarkus,
    main;

    public static final String QUARKUS_VERSION = "3.27.0";
    public static final String SPRING_BOOT_VERSION = "3.5.7";

    public static RuntimeType fromValue(String value) {
        return switch (value = value.toLowerCase(Locale.ROOT)) {
            case "spring", "spring-boot", "camel-spring-boot" -> springBoot;
            case "quarkus", "camel-quarkus" -> quarkus;
            case "main", "camel-main", "camel" -> main;
            default -> throw new IllegalArgumentException("Unsupported runtime " + value);
        };
    }

    public String runtime() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "spring-boot";
            case 1 -> "quarkus";
            case 2 -> "main";
        };
    }

    public String version() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> SPRING_BOOT_VERSION;
            case 1 -> QUARKUS_VERSION;
            case 2 -> new DefaultCamelCatalog().getCatalogVersion();
        };
    }

    public String toString() {
        return this.runtime();
    }
}

