/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.util.StringJoiner;
import org.apache.camel.util.ObjectHelper;

public interface Printer {
    public void println();

    public void println(String var1);

    public void print(String var1);

    public void printf(String var1, Object ... var2);

    default public void printErr(String message) {
        this.printf("ERROR: %s%n", message);
    }

    default public void printErr(String message, Exception e) {
        this.printErr("%s - %s".formatted(message, e.getMessage()));
    }

    default public void printErr(Exception e) {
        Iterable it = ObjectHelper.createExceptionIterable((Throwable)e);
        StringJoiner sj = new StringJoiner("\n\t --> ");
        for (Throwable t : it) {
            sj.add(t.getMessage());
        }
        this.printErr(sj.toString());
    }

    public static class QuietPrinter
    implements Printer {
        private final Printer delegate;

        public QuietPrinter(Printer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void println() {
        }

        @Override
        public void println(String line) {
        }

        @Override
        public void print(String output) {
        }

        @Override
        public void printf(String format, Object ... args) {
        }

        @Override
        public void printErr(String message) {
            this.delegate.printErr(message);
        }
    }

    public static class SystemOutPrinter
    implements Printer {
        @Override
        public void println() {
            System.out.println();
            System.out.flush();
        }

        @Override
        public void println(String line) {
            System.out.println(line);
            System.out.flush();
        }

        @Override
        public void print(String output) {
            System.out.print(output);
        }

        @Override
        public void printf(String format, Object ... args) {
            System.out.printf(format, args);
        }
    }
}

