/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CamelJBangPlugin;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.Plugin;
import org.apache.camel.dsl.jbang.core.common.PluginType;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.impl.engine.DefaultFactoryFinder;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

public final class PluginHelper {
    public static final String PLUGIN_CONFIG = ".camel-jbang-plugins.json";
    public static final String PLUGIN_SERVICE_DIR = "META-INF/services/org/apache/camel/camel-jbang-plugin/";
    private static final FactoryFinder FACTORY_FINDER = new DefaultFactoryFinder((ClassResolver)new DefaultClassResolver(), "META-INF/services/org/apache/camel/camel-jbang-plugin/");

    private PluginHelper() {
    }

    public static void addPlugins(CommandLine commandLine, CamelJBangMain main, String ... args) {
        String target = args != null && args.length > 0 ? args[0] : null;
        boolean foundEmbeddedPlugins = false;
        try {
            foundEmbeddedPlugins = PluginHelper.addEmbeddedPlugins(commandLine, main, target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (foundEmbeddedPlugins && target != null && !"shell".equals(target) && commandLine.getSubcommands().containsKey(target)) {
            return;
        }
        Map<String, Plugin> plugins = PluginHelper.getActivePlugins(main);
        for (Map.Entry<String, Plugin> plugin : plugins.entrySet()) {
            if (target != null && !"shell".equals(target) && !target.equals(plugin.getKey()) || foundEmbeddedPlugins && commandLine.getSubcommands().containsKey(plugin.getKey())) continue;
            plugin.getValue().customize(commandLine, main);
        }
    }

    public static Map<String, Plugin> getActivePlugins(CamelJBangMain main) {
        HashMap<String, Plugin> activePlugins = new HashMap<String, Plugin>();
        JsonObject config = PluginHelper.getPluginConfig();
        if (config != null) {
            DefaultCamelCatalog catalog = new DefaultCamelCatalog();
            String version = catalog.getCatalogVersion();
            JsonObject plugins = (JsonObject)config.getMap("plugins");
            for (String pluginKey : plugins.keySet()) {
                Optional<Plugin> plugin;
                JsonObject properties = (JsonObject)plugins.getMap(pluginKey);
                String name = properties.getOrDefault((Object)"name", (Object)pluginKey).toString();
                String command = properties.getOrDefault((Object)"command", (Object)name).toString();
                String firstVersion = properties.getOrDefault((Object)"firstVersion", (Object)"").toString();
                String gav = properties.getOrDefault((Object)"dependency", (Object)"").toString();
                if (!version.isBlank() && !firstVersion.isBlank()) {
                    PluginHelper.versionCheck(main, version, firstVersion, command);
                }
                if ((plugin = PluginHelper.getPlugin(command, version, gav, main.getOut())).isPresent()) {
                    activePlugins.put(command, plugin.get());
                    continue;
                }
                main.getOut().println("camel-jbang-plugin-" + command + " not found. Exit");
                main.quit(1);
            }
        }
        return activePlugins;
    }

    public static Optional<Plugin> getPlugin(String name, String defaultVersion, String gav, Printer printer) {
        Optional<Plugin> plugin = FACTORY_FINDER.newInstance("camel-jbang-plugin-" + name, Plugin.class);
        if (plugin.isEmpty()) {
            MavenGav mavenGav = PluginHelper.dependencyAsMavenGav(gav);
            String group = PluginHelper.extractGroup(mavenGav, "org.apache.camel");
            String depVersion = PluginHelper.extractVersion(mavenGav, defaultVersion);
            plugin = PluginHelper.downloadPlugin(name, depVersion, group, printer);
        }
        return plugin;
    }

    private static MavenGav dependencyAsMavenGav(String gav) {
        if (gav == null || gav.isEmpty()) {
            return null;
        }
        return MavenGav.parseGav((String)gav);
    }

    static void versionCheck(CamelJBangMain main, String version, String firstVersion, String command) {
        boolean accept;
        String source = version;
        if (source.endsWith("-SNAPSHOT")) {
            source = source.replace("-SNAPSHOT", "");
        }
        if (!(accept = VersionHelper.isGE(source, firstVersion))) {
            main.getOut().println("Cannot load plugin camel-jbang-plugin-" + command + " with version: " + version + " because plugin has first version: " + firstVersion + ". Exit");
            main.quit(1);
        }
    }

    private static Optional<Plugin> downloadPlugin(String command, String version, String group, Printer printer) {
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        DependencyDownloaderClassLoader ddlcl = new DependencyDownloaderClassLoader(PluginHelper.class.getClassLoader());
        downloader.setClassLoader((ClassLoader)ddlcl);
        downloader.start();
        downloader.downloadDependencyWithParent("org.apache.camel:camel-jbang-parent:" + version, group, "camel-jbang-plugin-" + command, version);
        Optional<Plugin> instance = Optional.empty();
        InputStream in = null;
        String path = "META-INF/services/org/apache/camel/camel-jbang-plugin/camel-jbang-plugin-" + command;
        try {
            in = ddlcl.getResourceAsStream(path);
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                String pluginClassName = prop.getProperty("class");
                DefaultClassResolver resolver = new DefaultClassResolver();
                Class pluginClass = resolver.resolveClass(pluginClassName, (ClassLoader)ddlcl);
                instance = Optional.of((Plugin)Plugin.class.cast(ObjectHelper.newInstance((Class)pluginClass)));
            } else {
                String gav = String.join((CharSequence)":", group, "camel-jbang-plugin-" + command, version);
                printer.printf(String.format("ERROR: Failed to read file %s in dependency %s%n", path, gav), new Object[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException(String.format("Failed to read the file %s.", path), (Throwable)e);
        }
        finally {
            downloader.stop();
            IOHelper.close((Closeable)in);
        }
        return instance;
    }

    public static JsonObject getOrCreatePluginConfig() {
        return Optional.ofNullable(PluginHelper.getPluginConfig()).orElseGet(PluginHelper::createPluginConfig);
    }

    static JsonObject getPluginConfig() {
        try {
            Path f = CommandLineHelper.getHomeDir().resolve(PLUGIN_CONFIG);
            if (Files.exists(f, new LinkOption[0])) {
                String text = Files.readString(f);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static JsonObject createPluginConfig() {
        Path f = CommandLineHelper.getHomeDir().resolve(PLUGIN_CONFIG);
        JsonObject config = Jsoner.deserialize((String)"{ \"plugins\": {} }", (JsonObject)new JsonObject());
        try {
            Files.writeString(f, (CharSequence)config.toJson(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Failed to create plugin configuration", (Throwable)e);
        }
        return config;
    }

    public static void savePluginConfig(JsonObject plugins) {
        Path f = CommandLineHelper.getHomeDir().resolve(PLUGIN_CONFIG);
        try {
            Files.writeString(f, (CharSequence)plugins.toJson(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Failed to save plugin configuration", (Throwable)e);
        }
    }

    public static void enable(PluginType pluginType) {
        JsonObject pluginConfig = PluginHelper.getOrCreatePluginConfig();
        JsonObject plugins = (JsonObject)pluginConfig.getMap("plugins");
        JsonObject kubePlugin = new JsonObject();
        kubePlugin.put((Object)"name", (Object)pluginType.getName());
        kubePlugin.put((Object)"command", (Object)pluginType.getCommand());
        kubePlugin.put((Object)"description", (Object)pluginType.getDescription());
        kubePlugin.put((Object)"firstVersion", (Object)pluginType.getFirstVersion());
        plugins.put((Object)pluginType.getName(), (Object)kubePlugin);
        PluginHelper.savePluginConfig(pluginConfig);
    }

    private static String doExtractInfo(MavenGav gav, String defaultInfo, Supplier<String> supplier) {
        String info;
        if (gav != null && (info = supplier.get()) != null) {
            return info;
        }
        return defaultInfo;
    }

    private static String extractGroup(MavenGav gav, String defaultGroup) {
        return PluginHelper.doExtractInfo(gav, defaultGroup, gav != null ? () -> ((MavenGav)gav).getGroupId() : () -> "");
    }

    private static String extractVersion(MavenGav gav, String defaultVersion) {
        return PluginHelper.doExtractInfo(gav, defaultVersion, gav != null ? () -> ((MavenGav)gav).getVersion() : () -> "");
    }

    public static boolean addEmbeddedPlugins(CommandLine commandLine, CamelJBangMain main, String target) {
        boolean foundAny = false;
        try {
            ClassLoader classLoader = PluginHelper.class.getClassLoader();
            Enumeration<URL> resources = classLoader.getResources(PLUGIN_SERVICE_DIR);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (!url.getProtocol().equals("jar")) continue;
                foundAny = PluginHelper.scanJarForPlugins(commandLine, main, target, classLoader, url);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return foundAny;
    }

    private static boolean scanJarForPlugins(CommandLine commandLine, CamelJBangMain main, String target, ClassLoader classLoader, URL jarUrl) {
        boolean foundAny = false;
        try {
            String jarPath = jarUrl.getPath();
            if (jarPath.startsWith("file:")) {
                jarPath = jarPath.substring(5);
            }
            if (jarPath.contains("!")) {
                jarPath = jarPath.substring(0, jarPath.indexOf("!"));
            }
            try (JarFile jarFile = new JarFile(jarPath);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(PLUGIN_SERVICE_DIR) || entryName.endsWith("/")) continue;
                    String pluginName = entryName.substring(entryName.lastIndexOf("/") + 1);
                    URL serviceUrl = classLoader.getResource(entryName);
                    if (serviceUrl == null || !PluginHelper.loadPluginFromService(commandLine, main, target, classLoader, serviceUrl, pluginName)) continue;
                    foundAny = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return foundAny;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadPluginFromService(CommandLine commandLine, CamelJBangMain main, String target, ClassLoader classLoader, URL serviceUrl, String pluginName) {
        try (InputStream is = serviceUrl.openStream();){
            Properties prop = new Properties();
            prop.load(is);
            String pluginClassName = prop.getProperty("class");
            if (pluginClassName == null) return false;
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            Plugin plugin = (Plugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String command = PluginHelper.extractCommandFromPlugin(pluginClass, pluginName);
            if (target != null && !"shell".equals(target) && !target.equals(command)) {
                boolean bl = false;
                return bl;
            }
            CamelJBangPlugin annotation = pluginClass.getAnnotation(CamelJBangPlugin.class);
            if (annotation != null) {
                DefaultCamelCatalog catalog = new DefaultCamelCatalog();
                String version = catalog.getCatalogVersion();
                String firstVersion = annotation.firstVersion();
                if (!version.isBlank() && !firstVersion.isBlank()) {
                    PluginHelper.versionCheck(main, version, firstVersion, command);
                }
            }
            plugin.customize(commandLine, main);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String extractCommandFromPlugin(Class<?> pluginClass, String pluginName) {
        if (pluginName.startsWith("camel-jbang-plugin-")) {
            return pluginName.substring("camel-jbang-plugin-".length());
        }
        String className = pluginClass.getSimpleName();
        if (className.endsWith("Plugin")) {
            String command = className.substring(0, className.length() - 6).toLowerCase();
            return command;
        }
        return pluginName;
    }

    public static boolean hasEmbeddedPlugins() {
        try {
            ClassLoader classLoader = PluginHelper.class.getClassLoader();
            String serviceDir = PLUGIN_SERVICE_DIR;
            Enumeration<URL> resources = classLoader.getResources(serviceDir);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (!url.getProtocol().equals("jar")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

