/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;

public final class PathUtils {
    private PathUtils() {
    }

    public static boolean deleteFile(Path path) {
        try {
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeTextSafely(String text, Path path) {
        try {
            Files.writeString(path, (CharSequence)text, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromStream(InputStream input, Path target, boolean closeInput) throws IOException {
        try {
            Path parent = target.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(input, target, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (closeInput && input != null) {
                input.close();
            }
        }
    }

    public static boolean deleteDirectory(Path directory) {
        if (directory == null || !Files.exists(directory, new LinkOption[0])) {
            return false;
        }
        try {
            Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void copyDirectory(Path sourceDir, Path targetDir) throws IOException {
        if (!Files.exists(sourceDir, new LinkOption[0]) || !Files.isDirectory(sourceDir, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(targetDir, new LinkOption[0])) {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        try (Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Path target = targetDir.resolve(sourceDir.relativize((Path)source));
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        if (!Files.exists(target, new LinkOption[0])) {
                            Files.createDirectories(target, new FileAttribute[0]);
                        }
                    } else {
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

