/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.StringJoiner;
import org.apache.camel.util.FileUtil;

public final class GistHelper {
    private GistHelper() {
    }

    public static String asGistSingleUrl(String url) {
        if (url.startsWith("https://gist.githubusercontent.com/")) {
            url = url.substring(35);
        } else if (url.startsWith("https://gist.github.com/")) {
            url = url.substring(24);
        }
        url = url.replaceFirst("/", ":");
        url = url.replaceFirst("/raw/", ":");
        url = url.replaceFirst("/", ":");
        return "gist:" + url;
    }

    public static void fetchGistUrls(String url, StringJoiner all) throws Exception {
        GistHelper.doFetchGistUrls(url, null, null, null, all);
    }

    public static void fetchGistUrls(String url, StringJoiner routes, StringJoiner kamelets, StringJoiner properties) throws Exception {
        GistHelper.doFetchGistUrls(url, routes, kamelets, properties, null);
    }

    private static void doFetchGistUrls(String url, StringJoiner routes, StringJoiner kamelets, StringJoiner properties, StringJoiner all) throws Exception {
        String[] parts = ((String)(url = ((String)url).substring(24))).split("/");
        if (parts.length < 2) {
            return;
        }
        String gid = parts[1];
        url = "https://api.github.com/gists/" + gid;
        GistHelper.resolveGistAsRawFiles((String)url, routes, kamelets, properties, all);
    }

    private static void resolveGistAsRawFiles(String url, StringJoiner routes, StringJoiner kamelets, StringJoiner properties, StringJoiner all) throws Exception {
        HttpClient hc = HttpClient.newHttpClient();
        HttpResponse<String> res = hc.send(HttpRequest.newBuilder(new URI(url)).timeout(Duration.ofSeconds(20L)).build(), HttpResponse.BodyHandlers.ofString());
        if (res.statusCode() == 200) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(res.body());
            for (JsonNode c : root.get("files")) {
                String u;
                String rawUrl;
                String name = c.get("filename").asText();
                String ext = FileUtil.onlyExt((String)name, (boolean)false);
                if (kamelets != null && "kamelet.yaml".equalsIgnoreCase(ext)) {
                    rawUrl = c.get("raw_url").asText();
                    u = GistHelper.asGistSingleUrl(rawUrl);
                    kamelets.add(u);
                    continue;
                }
                if (properties != null && "properties".equalsIgnoreCase(ext)) {
                    rawUrl = c.get("raw_url").asText();
                    u = GistHelper.asGistSingleUrl(rawUrl);
                    properties.add(u);
                    continue;
                }
                if (routes != null) {
                    if (!"java".equalsIgnoreCase(ext) && !"xml".equalsIgnoreCase(ext) && !"yaml".equalsIgnoreCase(ext) && !"camel.yaml".equalsIgnoreCase(ext)) continue;
                    rawUrl = c.get("raw_url").asText();
                    u = GistHelper.asGistSingleUrl(rawUrl);
                    routes.add(u);
                    continue;
                }
                if (all == null) continue;
                rawUrl = c.get("raw_url").asText();
                u = GistHelper.asGistSingleUrl(rawUrl);
                all.add(u);
            }
        }
    }
}

