/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.util.OrderedProperties;
import picocli.CommandLine;

public final class CommandLineHelper {
    private static volatile Path homeDir = Paths.get(System.getProperty("user.home"), new String[0]);
    public static final String USER_CONFIG = ".camel-jbang-user.properties";
    public static final String LOCAL_USER_CONFIG = "camel-jbang-user.properties";
    public static final String CAMEL_DIR = ".camel";
    public static final String CAMEL_JBANG_WORK_DIR = ".camel-jbang";

    private CommandLineHelper() {
    }

    public static void augmentWithUserConfiguration(CommandLine commandLine) {
        Path file = CommandLineHelper.getUserConfigurationFile();
        if (Files.isRegularFile(file, new LinkOption[0]) && Files.exists(file, new LinkOption[0])) {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException e) {
                commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new CamelUserConfigDefaultValueProvider(file));
            }
            commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new CamelUserConfigDefaultValueProvider(properties));
        }
    }

    private static Path getUserConfigurationFile() {
        Path file = Files.exists(Paths.get(LOCAL_USER_CONFIG, new String[0]), new LinkOption[0]) ? Paths.get(LOCAL_USER_CONFIG, new String[0]) : CommandLineHelper.getUserPropertyFile(false);
        return file;
    }

    public static void createPropertyFile(boolean local) throws IOException {
        Path file = CommandLineHelper.getUserPropertyFile(local);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
    }

    public static void loadProperties(Consumer<Properties> consumer) {
        CommandLineHelper.loadProperties(consumer, false);
    }

    public static void loadProperties(Consumer<Properties> consumer, boolean local) {
        Path file = CommandLineHelper.getUserPropertyFile(local);
        if (Files.isRegularFile(file, new LinkOption[0]) && Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                OrderedProperties prop = new OrderedProperties();
                prop.load(is);
                consumer.accept((Properties)prop);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load user configuration: " + String.valueOf(file));
            }
        }
    }

    public static void storeProperties(Properties properties, Printer printer, boolean local) {
        block9: {
            Path file = CommandLineHelper.getUserPropertyFile(local);
            if (Files.isRegularFile(file, new LinkOption[0]) && Files.exists(file, new LinkOption[0])) {
                try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                    properties.store(os, null);
                    break block9;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            printer.println(String.valueOf(file.getFileName()) + " does not exist");
        }
    }

    private static Path getUserPropertyFile(boolean local) {
        if (local) {
            return Paths.get(LOCAL_USER_CONFIG, new String[0]);
        }
        return homeDir.resolve(USER_CONFIG);
    }

    public static Path getHomeDir() {
        return homeDir;
    }

    public static void useHomeDir(String homeDir) {
        CommandLineHelper.homeDir = Paths.get(homeDir, new String[0]);
    }

    public static Path getCamelDir() {
        return homeDir.resolve(CAMEL_DIR);
    }

    public static Path getWorkDir() {
        return Paths.get(CAMEL_JBANG_WORK_DIR, new String[0]);
    }

    private static class CamelUserConfigDefaultValueProvider
    extends CommandLine.PropertiesDefaultProvider {
        public CamelUserConfigDefaultValueProvider(Path file) {
            super(file.toFile());
        }

        public CamelUserConfigDefaultValueProvider(Properties properties) {
            super(properties);
        }
    }
}

