/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.dsl.jbang.core.common.PropertyResolver;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.dsl.jbang.core.common.XmlHelper;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DownloadException;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class CatalogLoader {
    public static final String QUARKUS_GROUP_ID = "io.quarkus.platform";
    private static final String DEFAULT_CAMEL_CATALOG = "org.apache.camel.catalog.DefaultCamelCatalog";
    private static final String SPRING_BOOT_CATALOG_PROVIDER = "org.apache.camel.springboot.catalog.SpringBootRuntimeProvider";
    private static final String QUARKUS_CATALOG_PROVIDER = "org.apache.camel.catalog.quarkus.QuarkusRuntimeProvider";

    private CatalogLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CamelCatalog loadCatalog(String repos, String version, boolean download) throws Exception {
        DefaultCamelCatalog answer = new DefaultCamelCatalog();
        if (version == null || version.isEmpty() || version.equals(answer.getCatalogVersion())) {
            answer.enableCache();
            return answer;
        }
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(null);
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setRepositories(repos);
        downloader.setDownload(download);
        try {
            downloader.start();
            MavenArtifact ma = downloader.downloadArtifact("org.apache.camel", "camel-catalog", version);
            if (ma == null) {
                throw new IOException("Cannot download org.apache.camel:camel-catalog:" + version);
            }
            cl.addFile(ma.getFile());
            Class clazz = cl.loadClass(DEFAULT_CAMEL_CATALOG);
            if (clazz != null) {
                answer.setVersionManager((VersionManager)new DownloadCatalogVersionManager(version, (ClassLoader)cl));
                RuntimeProvider provider = (RuntimeProvider)ObjectHelper.newInstance((Class)clazz);
                if (provider != null) {
                    answer.setRuntimeProvider(provider);
                }
            }
            answer.enableCache();
        }
        finally {
            downloader.stop();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CamelCatalog loadSpringBootCatalog(String repos, String version, boolean download) throws Exception {
        DefaultCamelCatalog answer = new DefaultCamelCatalog();
        if (version == null) {
            version = answer.getCatalogVersion();
        }
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CatalogLoader.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setRepositories(repos);
        downloader.setDownload(download);
        try {
            MavenArtifact ma;
            downloader.start();
            String camelCatalogVersion = version;
            try {
                ma = downloader.downloadArtifact("org.apache.camel", "camel-catalog", camelCatalogVersion);
            }
            catch (DownloadException ex) {
                camelCatalogVersion = answer.getCatalogVersion();
                ma = downloader.downloadArtifact("org.apache.camel", "camel-catalog", camelCatalogVersion);
            }
            if (ma == null) {
                throw new IOException("Cannot download org.apache.camel:camel-catalog:" + camelCatalogVersion);
            }
            cl.addFile(ma.getFile());
            String camelVersion = version;
            ma = downloader.downloadArtifact("org.apache.camel.springboot", "camel-catalog-provider-springboot", PropertyResolver.fromSystemProperty("camel.jbang.camelSpringBootVersion", () -> camelVersion));
            if (ma == null) {
                throw new IOException("Cannot download org.apache.camel.springboot:camel-catalog-provider-springboot:" + version);
            }
            cl.addFile(ma.getFile());
            Class clazz = cl.loadClass(SPRING_BOOT_CATALOG_PROVIDER);
            if (clazz != null) {
                RuntimeProvider provider;
                Class clazz2 = cl.loadClass(DEFAULT_CAMEL_CATALOG);
                if (clazz2 != null) {
                    answer = (CamelCatalog)ObjectHelper.newInstance((Class)clazz2);
                }
                if ((provider = (RuntimeProvider)ObjectHelper.newInstance((Class)clazz)) != null) {
                    answer.setRuntimeProvider(provider);
                }
                answer.getVersionManager().setClassLoader((ClassLoader)cl);
            }
            answer.enableCache();
        }
        finally {
            downloader.stop();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CamelCatalog loadQuarkusCatalog(String repos, String quarkusVersion, String quarkusGroupId, boolean download) throws Exception {
        String camelQuarkusVersion = null;
        DefaultCamelCatalog answer = new DefaultCamelCatalog();
        if (quarkusVersion == null) {
            return answer;
        }
        boolean finalSuffix = VersionHelper.isLE((String)quarkusVersion, "3.2.0");
        if (finalSuffix && !((String)quarkusVersion).endsWith(".Final")) {
            quarkusVersion = (String)quarkusVersion + ".Final";
        }
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CatalogLoader.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setRepositories(repos);
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setDownload(download);
        try {
            List artifacts;
            String name;
            File file;
            MavenArtifact ma;
            downloader.start();
            if (quarkusGroupId == null) {
                quarkusGroupId = QUARKUS_GROUP_ID;
            }
            if ((ma = downloader.downloadArtifact(quarkusGroupId, "quarkus-camel-bom:pom", (String)quarkusVersion)) != null && ma.getFile() != null && (file = new File(name = ma.getFile().getAbsolutePath())).exists()) {
                DocumentBuilderFactory dbf = XmlHelper.createDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(file);
                NodeList nl = dom.getElementsByTagName("dependency");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element node = (Element)nl.item(i);
                    String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                    String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                    if (!"org.apache.camel.quarkus".equals(g) || !"camel-quarkus-catalog".equals(a)) continue;
                    camelQuarkusVersion = node.getElementsByTagName("version").item(0).getTextContent();
                }
            }
            if (camelQuarkusVersion != null && (artifacts = downloader.downloadArtifacts("org.apache.camel.quarkus", "camel-quarkus-catalog", camelQuarkusVersion, true)) != null) {
                downloader.downloadDependency("org.apache.camel.quarkus", "camel-quarkus-catalog", camelQuarkusVersion);
                Class clazz = cl.loadClass(QUARKUS_CATALOG_PROVIDER);
                if (clazz != null) {
                    RuntimeProvider provider;
                    Class clazz2 = cl.loadClass(DEFAULT_CAMEL_CATALOG);
                    if (clazz2 != null) {
                        answer = (CamelCatalog)ObjectHelper.newInstance((Class)clazz2);
                    }
                    if ((provider = (RuntimeProvider)ObjectHelper.newInstance((Class)clazz)) != null) {
                        answer.setRuntimeProvider(provider);
                    }
                    answer.getVersionManager().setClassLoader((ClassLoader)cl);
                }
            }
            answer.enableCache();
        }
        finally {
            downloader.stop();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveCamelVersionFromSpringBoot(String repos, String camelSpringBootVersion, boolean download) throws Exception {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CatalogLoader.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setRepositories(repos);
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setDownload(download);
        try {
            downloader.start();
            List artifacts = downloader.downloadArtifacts("org.apache.camel.springboot", "camel-catalog-provider-springboot", camelSpringBootVersion, true);
            for (MavenArtifact ma : artifacts) {
                String g = ma.getGav().getGroupId();
                String a = ma.getGav().getArtifactId();
                if (!"org.apache.camel".equals(g) || !"camel-catalog".equals(a)) continue;
                String string = ma.getGav().getVersion();
                return string;
            }
        }
        finally {
            downloader.stop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveSpringBootVersionFromCamelSpringBoot(String repos, String camelSpringBootVersion, boolean download) throws Exception {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CatalogLoader.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setRepositories(repos);
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setDownload(download);
        try {
            downloader.start();
            List artifacts = downloader.downloadArtifacts("org.apache.camel.springboot", "camel-core-starter", camelSpringBootVersion, true);
            for (MavenArtifact ma : artifacts) {
                String g = ma.getGav().getGroupId();
                String a = ma.getGav().getArtifactId();
                if (!"org.springframework.boot".equals(g) || !"spring-boot-starter".equals(a)) continue;
                String string = ma.getGav().getVersion();
                return string;
            }
        }
        finally {
            downloader.stop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveCamelVersionFromQuarkus(String repos, String camelQuarkusVersion, boolean download) throws Exception {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(CatalogLoader.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setRepositories(repos);
        downloader.setClassLoader((ClassLoader)cl);
        downloader.setDownload(download);
        try {
            downloader.start();
            List artifacts = downloader.downloadArtifacts("org.apache.camel.quarkus", "camel-quarkus-catalog", camelQuarkusVersion, true);
            for (MavenArtifact ma : artifacts) {
                String g = ma.getGav().getGroupId();
                String a = ma.getGav().getArtifactId();
                if (!"org.apache.camel".equals(g) || !"camel-catalog".equals(a)) continue;
                String string = ma.getGav().getVersion();
                return string;
            }
        }
        finally {
            downloader.stop();
        }
        return null;
    }

    private static final class DownloadCatalogVersionManager
    implements VersionManager {
        private ClassLoader classLoader;
        private final String version;

        public DownloadCatalogVersionManager(String version, ClassLoader classLoader) {
            this.version = version;
            this.classLoader = classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getLoadedVersion() {
            return this.version;
        }

        public boolean loadVersion(String version) {
            return this.version.equals(version);
        }

        public String getRuntimeProviderLoadedVersion() {
            return this.version;
        }

        public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
            return true;
        }

        public InputStream getResourceAsStream(String name) {
            return this.classLoader.getResourceAsStream(name);
        }
    }
}

