/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import org.apache.camel.dsl.jbang.core.common.JSonHelper;
import org.apache.camel.dsl.jbang.core.common.XmlHelper;
import org.apache.camel.util.json.Jsoner;

public final class CamelCommandHelper {
    public static final String CAMEL_INSTANCE_TYPE = "camel.jbang";

    private CamelCommandHelper() {
    }

    public static String extractState(int status) {
        if (status <= 4) {
            return "Starting";
        }
        if (status == 5) {
            return "Running";
        }
        if (status == 6) {
            return "Suspending";
        }
        if (status == 7) {
            return "Suspended";
        }
        if (status == 8) {
            return "Terminating";
        }
        if (status == 9) {
            return "Terminated";
        }
        return "Terminated";
    }

    public static String valueAsStringPretty(Object value, boolean loggingColor) {
        if (value == null) {
            return "null";
        }
        boolean json = false;
        String s = value.toString();
        if (!s.isEmpty()) {
            try {
                s = Jsoner.unescape((String)s);
                s = loggingColor ? JSonHelper.colorPrint(s, 2, true) : JSonHelper.prettyPrint(s, 2);
                if (s != null && !s.isEmpty()) {
                    json = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (s == null || s.isEmpty()) {
                s = value.toString();
            }
            if (!json) {
                try {
                    s = Jsoner.unescape((String)s);
                    s = loggingColor ? XmlHelper.colorPrint(s, 2, true) : XmlHelper.prettyPrint(s, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (s == null || s.isEmpty()) {
                s = value.toString();
            }
        }
        if (s == null) {
            return "null";
        }
        return s;
    }
}

