/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.update;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.update.CamelQuarkusUpdate;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdate;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateException;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateMixin;
import org.apache.camel.dsl.jbang.core.commands.update.Update;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.main.download.DownloadException;
import org.apache.camel.main.download.MavenDependencyDownloader;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Update Camel project"})
public class UpdateRun
extends CamelCommand {
    @CommandLine.Mixin
    private CamelUpdateMixin updateMixin;

    public UpdateRun(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (Files.list(Path.of(".", new String[0])).noneMatch(f -> f.getFileName().toString().equals("pom.xml"))) {
            this.printer().println("No Maven Project found in the current directory, please execute camel upgrade run command in the directory containing the Maven project to update");
            return -1;
        }
        ArrayList<String> command = new ArrayList();
        try (MavenDependencyDownloader downloader = new MavenDependencyDownloader();){
            downloader.setRepositories(this.updateMixin.repos);
            downloader.start();
            Update update = null;
            try {
                if (this.updateMixin.runtime == RuntimeType.quarkus) {
                    update = new CamelQuarkusUpdate(this.updateMixin, downloader);
                    command = update.command();
                } else {
                    update = new CamelUpdate(this.updateMixin, downloader);
                    command = update.command();
                }
            }
            catch (CamelUpdateException ex) {
                this.printer().println(ex.getMessage());
                Integer n = -1;
                downloader.close();
                return n;
            }
            catch (DownloadException e) {
                this.printer().println(String.format("Cannot find Camel Upgrade Recipes %s:%s:%s", "org.apache.camel.upgrade", update.getArtifactCoordinates(), this.updateMixin.version));
                Integer n = -1;
                downloader.close();
                return n;
            }
        }
        this.executeCommand(command);
        return 0;
    }

    private int executeCommand(List<String> command) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.redirectErrorStream(true).start();
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            int exitCode;
            BufferedReader stdError;
            block13: {
                int n;
                stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line;
                    while ((line = stdInput.readLine()) != null || (line = stdError.readLine()) != null) {
                        this.printer().println(line);
                    }
                    if (p.waitFor(this.updateMixin.upgradeTimeout, TimeUnit.SECONDS)) break block13;
                    p.destroyForcibly();
                    this.printer().println("Update execution timed out");
                    n = -1;
                }
                catch (Throwable throwable) {
                    try {
                        stdError.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                stdError.close();
                return n;
            }
            int n = exitCode = p.exitValue();
            stdError.close();
            return n;
        }
    }
}

