/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.update;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateException;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateMixin;
import org.apache.camel.dsl.jbang.core.commands.update.Update;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.tooling.maven.MavenArtifact;

public final class CamelUpdate
implements Update {
    private List<String> commands = new ArrayList<String>();
    private CamelUpdateMixin updateMixin;
    private MavenDependencyDownloader downloader;

    public CamelUpdate(CamelUpdateMixin updateMixin, MavenDependencyDownloader downloader) {
        this.updateMixin = updateMixin;
        this.downloader = downloader;
    }

    public List<String> activeRecipes() throws CamelUpdateException {
        List<Recipe> recipes;
        MavenArtifact mavenArtifact = this.downloader.downloadArtifact("org.apache.camel.upgrade", this.getArtifactCoordinates(), this.updateMixin.version);
        try {
            recipes = this.getRecipesInJar(mavenArtifact.getFile().toPath());
        }
        catch (IOException ex) {
            throw new CamelUpdateException(ex);
        }
        ArrayList<String> activeRecipes = new ArrayList<String>();
        for (Recipe recipe : recipes) {
            if (recipe.name().contains("latest")) {
                activeRecipes.clear();
                recipe.recipeName().ifPresent(name -> activeRecipes.add((String)name));
                break;
            }
            recipe.recipeName().ifPresent(name -> activeRecipes.add((String)name));
        }
        return activeRecipes;
    }

    private List<Recipe> getRecipesInJar(Path jar) throws IOException {
        ArrayList<Recipe> recipes;
        block12: {
            recipes = new ArrayList<Recipe>();
            try (FileSystem fileSystem = FileSystems.newFileSystem(jar, (ClassLoader)null);){
                Path recipePath = fileSystem.getPath("META-INF", "rewrite");
                if (!Files.exists(recipePath, new LinkOption[0])) break block12;
                try (Stream<Path> walk = Files.walk(recipePath, new FileVisitOption[0]);){
                    walk.filter(p -> p.toString().endsWith(".yaml")).forEach(p -> {
                        try {
                            recipes.add(new Recipe(p.getFileName().toString(), Files.readString(p)));
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
            }
        }
        return recipes;
    }

    @Override
    public String debug() {
        String result = "--no-transfer-progress";
        if (this.updateMixin.debug) {
            result = "-X";
        }
        return result;
    }

    @Override
    public String runMode() {
        String task = "run";
        if (this.updateMixin.dryRun) {
            task = "dryRun";
        }
        return task;
    }

    @Override
    public List<String> command() throws CamelUpdateException {
        this.commands.add(this.mvnProgramCall());
        this.commands.add(this.debug());
        this.commands.add("org.openrewrite.maven:rewrite-maven-plugin:" + this.updateMixin.openRewriteVersion + ":" + this.runMode());
        ArrayList<String> coordinates = new ArrayList<String>();
        coordinates.add(String.format("org.apache.camel.upgrade:%s:%s", this.getArtifactCoordinates(), this.updateMixin.version));
        if (this.updateMixin.extraRecipeArtifactCoordinates != null && !this.updateMixin.extraRecipeArtifactCoordinates.isEmpty()) {
            coordinates.addAll(this.updateMixin.extraRecipeArtifactCoordinates);
        }
        this.commands.add("-Drewrite.recipeArtifactCoordinates=" + coordinates.stream().collect(Collectors.joining(",")));
        ArrayList<String> recipes = new ArrayList<String>();
        recipes.addAll(this.activeRecipes());
        if (this.updateMixin.extraActiveRecipes != null && !this.updateMixin.extraActiveRecipes.isEmpty()) {
            recipes.addAll(this.updateMixin.extraActiveRecipes);
        }
        this.commands.add("-Drewrite.activeRecipes=" + recipes.stream().collect(Collectors.joining(",")));
        return this.commands;
    }

    @Override
    public String getArtifactCoordinates() {
        return this.updateMixin.runtime == RuntimeType.springBoot ? this.updateMixin.camelSpringBootArtifactCoordinates : this.updateMixin.camelArtifactCoordinates;
    }

    record Recipe(String name, String content) {
        public Optional<String> recipeName() {
            return Arrays.stream(this.content().split(System.lineSeparator())).filter(l -> l.startsWith("name") && l.contains("org.apache.camel.upgrade")).map(l -> l.substring(l.indexOf("org.apache.camel.upgrade"))).findFirst();
        }
    }
}

