/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.update;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateException;
import org.apache.camel.dsl.jbang.core.commands.update.CamelUpdateMixin;
import org.apache.camel.dsl.jbang.core.commands.update.Update;
import org.apache.camel.main.download.MavenDependencyDownloader;

public final class CamelQuarkusUpdate
implements Update {
    private List<String> commands = new ArrayList<String>();
    private CamelUpdateMixin updateMixin;
    private MavenDependencyDownloader downloader;
    private final String QUARKUS_UPDATE_ARTIFACTID = "camel-quarkus-catalog";

    public CamelQuarkusUpdate(CamelUpdateMixin updateMixin, MavenDependencyDownloader downloader) {
        this.updateMixin = updateMixin;
        this.downloader = downloader;
    }

    public String getQuarkusStream() {
        List qVersions = this.downloader.resolveAvailableVersions("org.apache.camel.quarkus", "camel-quarkus-catalog", this.updateMixin.version, this.updateMixin.repos);
        String streamVersion = null;
        for (String[] qVersion : qVersions) {
            if (!qVersion[0].equals(this.updateMixin.version)) continue;
            streamVersion = qVersion[1].substring(0, qVersion[1].lastIndexOf(46));
        }
        return streamVersion;
    }

    @Override
    public String debug() {
        String result = "--no-transfer-progress";
        if (this.updateMixin.debug) {
            result = "-X";
        }
        return result;
    }

    @Override
    public String runMode() {
        String result = "-DrewriteFullRun";
        if (this.updateMixin.dryRun) {
            result = "-DrewriteDryRun";
        }
        return result;
    }

    @Override
    public List<String> command() throws CamelUpdateException {
        this.commands.add(this.mvnProgramCall());
        this.commands.add(this.debug());
        this.commands.add(String.format("%s:quarkus-maven-plugin:%s:update", this.updateMixin.quarkusMavenPluginGroupId, this.updateMixin.quarkusMavenPluginVersion));
        this.commands.add("-Dstream=" + this.getQuarkusStream());
        this.commands.add(this.runMode());
        return this.commands;
    }

    @Override
    public String getArtifactCoordinates() {
        return "camel-quarkus-catalog";
    }
}

