/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="vault", description={"List secrets from security vaults"}, sortOptions=false, showDefaultValues=true)
public class ListVault
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameCompletionCandidates.class, description={"Sort by pid, name"}, defaultValue="pid")
    String sort;

    public ListVault(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject vaults;
                Row row = new Row();
                row.pid = Long.toString(ph.pid());
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                if ((vaults = (JsonObject)root.get((Object)"vaults")) != null) {
                    JsonObject cmKubernetes;
                    JsonObject hashicorp;
                    JsonObject kubernetes;
                    JsonObject azure;
                    JsonObject gcp;
                    JsonObject aws = (JsonObject)vaults.get((Object)"aws-secrets");
                    if (aws != null) {
                        row.vault = "AWS";
                        row.region = aws.getString("region");
                        row.lastCheck = aws.getLongOrDefault("lastCheckTimestamp", 0L);
                        row.lastReload = aws.getLongOrDefault("lastReloadTimestamp", 0L);
                        JsonArray arr = (JsonArray)aws.get((Object)"secrets");
                        for (int i = 0; arr != null && i < arr.size(); ++i) {
                            if (i > 0) {
                                row = row.copy();
                            }
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.secret = jo.getString("name");
                            row.timestamp = jo.getLongOrDefault("timestamp", 0L);
                            rows.add(row);
                        }
                    }
                    if ((gcp = (JsonObject)vaults.get((Object)"gcp-secrets")) != null) {
                        row.vault = "GCP";
                        row.lastCheck = gcp.getLongOrDefault("lastCheckTimestamp", 0L);
                        row.lastReload = gcp.getLongOrDefault("lastReloadTimestamp", 0L);
                        JsonArray arr = (JsonArray)gcp.get((Object)"secrets");
                        for (int i = 0; arr != null && i < arr.size(); ++i) {
                            if (i > 0) {
                                row = row.copy();
                            }
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.secret = jo.getString("name");
                            row.timestamp = jo.getLongOrDefault("timestamp", 0L);
                            rows.add(row);
                        }
                    }
                    if ((azure = (JsonObject)vaults.get((Object)"azure-secrets")) != null) {
                        row.vault = "Azure";
                        row.lastCheck = azure.getLongOrDefault("lastCheckTimestamp", 0L);
                        row.lastReload = azure.getLongOrDefault("lastReloadTimestamp", 0L);
                        JsonArray arr = (JsonArray)azure.get((Object)"secrets");
                        for (int i = 0; arr != null && i < arr.size(); ++i) {
                            if (i > 0) {
                                row = row.copy();
                            }
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.secret = jo.getString("name");
                            row.timestamp = jo.getLongOrDefault("timestamp", 0L);
                            rows.add(row);
                        }
                    }
                    if ((kubernetes = (JsonObject)vaults.get((Object)"kubernetes-secrets")) != null) {
                        row.vault = "Kubernetes";
                        row.lastCheck = kubernetes.getLongOrDefault("startCheckTimestamp", 0L);
                        row.lastReload = kubernetes.getLongOrDefault("lastReloadTimestamp", 0L);
                        JsonArray arr = (JsonArray)kubernetes.get((Object)"secrets");
                        for (int i = 0; arr != null && i < arr.size(); ++i) {
                            if (i > 0) {
                                row = row.copy();
                            }
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.secret = jo.getString("name");
                            row.timestamp = jo.getLongOrDefault("timestamp", 0L);
                            rows.add(row);
                        }
                    }
                    if ((hashicorp = (JsonObject)vaults.get((Object)"hashicorp-secrets")) != null) {
                        row.vault = "Hashicorp";
                        row.lastCheck = hashicorp.getLongOrDefault("startCheckTimestamp", 0L);
                        row.lastReload = hashicorp.getLongOrDefault("lastReloadTimestamp", 0L);
                        rows.add(row);
                    }
                    if ((cmKubernetes = (JsonObject)vaults.get((Object)"kubernetes-configmaps")) != null) {
                        row.vault = "Kubernetes-cm";
                        row.lastCheck = cmKubernetes.getLongOrDefault("startCheckTimestamp", 0L);
                        row.lastReload = cmKubernetes.getLongOrDefault("lastReloadTimestamp", 0L);
                        JsonArray arr = (JsonArray)cmKubernetes.get((Object)"configmap");
                        for (int i = 0; arr != null && i < arr.size(); ++i) {
                            if (i > 0) {
                                row = row.copy();
                            }
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.secret = jo.getString("name");
                            row.timestamp = jo.getLongOrDefault("timestamp", 0L);
                            rows.add(row);
                        }
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("VAULT").dataAlign(HorizontalAlign.LEFT).with(r -> r.vault), new Column().header("REGION").dataAlign(HorizontalAlign.LEFT).with(r -> r.region), new Column().header("SECRET").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.secret), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(this::getAgo), new Column().header("UPDATE").headerAlign(HorizontalAlign.LEFT).with(this::getReloadAgo), new Column().header("CHECK").headerAlign(HorizontalAlign.LEFT).with(this::getCheckAgo))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
        }
        return 0;
    }

    private String getCheckAgo(Row r) {
        if (r.lastCheck == 0L) {
            return "";
        }
        return TimeUtils.printSince((long)r.lastCheck);
    }

    private String getReloadAgo(Row r) {
        if (r.lastReload == 0L) {
            return "";
        }
        return TimeUtils.printSince((long)r.lastReload);
    }

    private String getAgo(Row r) {
        if (r.timestamp == 0L) {
            return "";
        }
        return TimeUtils.printSince((long)r.timestamp);
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String vault;
        String region;
        long lastCheck;
        long lastReload;
        String secret;
        long timestamp;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class PidNameCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name").iterator();
        }
    }
}

