/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="variable", description={"List variables of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListVariable
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameKeyCompletionCandidates.class, description={"Sort by pid, name or key"}, defaultValue="pid")
    String sort;

    public ListVariable(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                JsonObject jv = (JsonObject)root.get((Object)"variables");
                if (jv != null) {
                    for (String id : jv.keySet()) {
                        JsonArray arr = (JsonArray)jv.getCollection(id);
                        if (arr == null) continue;
                        for (int i = 0; i < arr.size(); ++i) {
                            row = row.copy();
                            JsonObject jo = (JsonObject)arr.get(i);
                            row.id = id;
                            row.key = jo.getString("key");
                            row.type = jo.getString("type");
                            row.value = jo.get((Object)"value");
                            rows.add(row);
                        }
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("REPO").headerAlign(HorizontalAlign.CENTER).with(r -> r.id), new Column().header("TYPE").headerAlign(HorizontalAlign.CENTER).maxWidth(40, OverflowBehaviour.ELLIPSIS_LEFT).with(r -> r.type), new Column().header("KEY").dataAlign(HorizontalAlign.LEFT).maxWidth(50, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.key), new Column().header("VALUE").headerAlign(HorizontalAlign.RIGHT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getValue))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "key": {
                return o1.key.compareToIgnoreCase(o2.key) * negate;
            }
        }
        return 0;
    }

    private String getValue(Row r) {
        if (r.value != null) {
            Object s = r.value.toString();
            if (((String)s).length() > 300) {
                s = ((String)s).substring(0, 300) + "...";
            }
            return s;
        }
        return "";
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String id;
        String key;
        String type;
        Object value;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class PidNameKeyCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "key").iterator();
        }
    }
}

