/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="rest", description={"Get REST services of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListRest
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--verbose"}, description={"Show more details"})
    boolean verbose;

    public ListRest(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonArray arr;
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = ListRest.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                JsonObject jo = (JsonObject)root.get((Object)"rests");
                if (jo != null && (arr = (JsonArray)jo.get((Object)"rests")) != null) {
                    for (int i = 0; i < arr.size(); ++i) {
                        row = row.copy();
                        jo = (JsonObject)arr.get(i);
                        row.url = jo.getString("url");
                        row.method = jo.getString("method").toUpperCase(Locale.ROOT);
                        row.consumes = jo.getString("consumes");
                        row.produces = jo.getString("produces");
                        row.description = jo.getString("description");
                        row.contractFirst = jo.getBooleanOrDefault("contractFirst", false);
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("URL").dataAlign(HorizontalAlign.LEFT).with(r -> r.url), new Column().header("METHOD").dataAlign(HorizontalAlign.LEFT).with(r -> r.method), new Column().header("FIRST").visible(this.verbose).dataAlign(HorizontalAlign.LEFT).with(this::getKind), new Column().header("DESCRIPTION").visible(this.verbose).maxWidth(40, OverflowBehaviour.NEWLINE).dataAlign(HorizontalAlign.LEFT).with(r -> r.description), new Column().header("CONTENT-TYPE").dataAlign(HorizontalAlign.LEFT).with(this::getContent))));
        }
        return 0;
    }

    private String getKind(Row r) {
        return r.contractFirst ? "Contract" : "Code";
    }

    private String getContent(Row r) {
        StringJoiner sj = new StringJoiner("   ");
        if (r.consumes != null || r.produces != null) {
            if (r.consumes != null) {
                sj.add("accept: " + r.consumes);
            }
            if (r.produces != null) {
                sj.add("produces: " + r.produces);
            }
        }
        if (sj.length() > 0) {
            return sj.toString();
        }
        return "";
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String age;
        long uptime;
        String url;
        String method;
        String consumes;
        String produces;
        String description;
        boolean contractFirst;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

