/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="metric", description={"Get metrics (micrometer) of running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListMetric
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--filter"}, description={"Filter metric by type, name or tags"})
    String filter;
    @CommandLine.Option(names={"--tags"}, description={"Show metric tags"}, defaultValue="false")
    boolean tags;
    @CommandLine.Option(names={"--custom"}, description={"Only show custom metrics"}, defaultValue="false")
    boolean custom;
    @CommandLine.Option(names={"--all"}, description={"Whether to show all metrics (also unused with counter being 0)"}, defaultValue="false")
    boolean all;

    public ListMetric(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = ListMetric.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                Row baseRow = row.copy();
                JsonObject mo = (JsonObject)root.get((Object)"micrometer");
                if (mo != null) {
                    JsonObject jo;
                    int i;
                    JsonArray arr = (JsonArray)mo.get((Object)"counters");
                    if (arr != null) {
                        for (i = 0; i < arr.size(); ++i) {
                            row = baseRow.copy();
                            jo = (JsonObject)arr.get(i);
                            row.type = "counter";
                            row.metricName = jo.getString("name");
                            row.metricDescription = jo.getString("description");
                            row.metricId = this.extractId(jo);
                            row.tags = this.extractTags(jo);
                            row.count = jo.getDouble("count");
                            if (this.custom && row.metricName.startsWith("Camel") || !this.all && this.getNumber(row.count).isEmpty() || this.filter != null && !row.type.equals(this.filter) && !row.metricName.contains(this.filter)) continue;
                            rows.add(row);
                        }
                    }
                    if ((arr = (JsonArray)mo.get((Object)"timers")) != null) {
                        for (i = 0; i < arr.size(); ++i) {
                            row = baseRow.copy();
                            jo = (JsonObject)arr.get(i);
                            row.type = "timer";
                            row.metricName = jo.getString("name");
                            row.metricDescription = jo.getString("description");
                            row.metricId = this.extractId(jo);
                            row.tags = this.extractTags(jo);
                            row.count = jo.getDouble("count");
                            row.mean = jo.getDouble("mean");
                            row.max = jo.getDouble("max");
                            row.total = jo.getDouble("total");
                            if (this.custom && row.metricName.startsWith("Camel") || !this.all && this.getNumber(row.count).isEmpty() || this.filter != null && !row.type.equals(this.filter) && !row.metricName.contains(this.filter) && !row.tags.contains(this.filter)) continue;
                            rows.add(row);
                        }
                    }
                    if ((arr = (JsonArray)mo.get((Object)"gauges")) != null) {
                        for (i = 0; i < arr.size(); ++i) {
                            row = baseRow.copy();
                            jo = (JsonObject)arr.get(i);
                            row.type = "gauge";
                            row.metricName = jo.getString("name");
                            if ("app.info".equals(row.metricName)) continue;
                            row.metricDescription = jo.getString("description");
                            row.metricId = this.extractId(jo);
                            row.tags = this.extractTags(jo);
                            row.count = jo.getDouble("value");
                            if (this.custom && row.metricName.startsWith("Camel") || !this.all && this.getNumber(row.count).isEmpty() || this.filter != null && !row.type.equals(this.filter) && !row.metricName.contains(this.filter)) continue;
                            rows.add(row);
                        }
                    }
                    if ((arr = (JsonArray)mo.get((Object)"distribution")) != null) {
                        for (i = 0; i < arr.size(); ++i) {
                            row = baseRow.copy();
                            jo = (JsonObject)arr.get(i);
                            row.type = "distribution";
                            row.metricName = jo.getString("name");
                            row.metricDescription = jo.getString("description");
                            row.metricId = this.extractId(jo);
                            row.tags = this.extractTags(jo);
                            row.count = jo.getDouble("value");
                            row.mean = jo.getDouble("mean");
                            row.max = jo.getDouble("max");
                            row.total = jo.getDouble("totalAmount");
                            if (this.custom && row.metricName.startsWith("Camel") || !this.all && this.getNumber(row.count).isEmpty() || this.filter != null && !row.type.equals(this.filter) && !row.metricName.contains(this.filter)) continue;
                            rows.add(row);
                        }
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).with(r -> r.type), new Column().header("METRIC").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.metricName), new Column().header("ID").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.metricId), new Column().header("VALUE").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(r -> this.getNumber(r.count)), new Column().header("MEAN").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(r -> this.getNumber(r.mean)), new Column().header("MAX").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(r -> this.getNumber(r.max)), new Column().header("TOTAL").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(r -> this.getNumber(r.total)), new Column().header("TAGS").visible(this.tags).dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.NEWLINE).with(r -> r.tags))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        int answer = switch (s) {
            case "pid" -> Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            case "name" -> o1.name.compareToIgnoreCase(o2.name) * negate;
            case "age" -> Long.compare(o1.uptime, o2.uptime) * negate;
            default -> 0;
        };
        if (answer == 0 && (answer = o1.metricName.compareToIgnoreCase(o2.metricName) * negate) == 0) {
            answer = o1.metricId.compareToIgnoreCase(o2.metricId) * negate;
        }
        return answer;
    }

    private String getNumber(double d) {
        String s = Double.toString(d);
        if (s.equals("0.0") || s.equals("0,0")) {
            return "";
        }
        if (s.endsWith(".0") || s.endsWith(",0")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    private String extractId(JsonObject jo) {
        List tags = (List)jo.getCollection("tags");
        String routeId = null;
        String nodeId = null;
        if (tags != null) {
            for (JsonObject t : tags) {
                String k = t.getString("key");
                if ("routeId".equals(k)) {
                    routeId = t.getString("value");
                    continue;
                }
                if (!"nodeId".equals(k)) continue;
                nodeId = t.getString("value");
            }
        }
        if (routeId != null && nodeId != null) {
            return routeId + "/" + nodeId;
        }
        if (routeId != null) {
            return routeId;
        }
        if (nodeId != null) {
            return nodeId;
        }
        return "";
    }

    private String extractTags(JsonObject jo) {
        StringJoiner sj = new StringJoiner(" ");
        List tags = (List)jo.getCollection("tags");
        if (tags != null) {
            for (JsonObject t : tags) {
                String k = t.getString("key");
                String v = t.getString("value");
                sj.add(k + "=" + v);
            }
        }
        return sj.toString();
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String age;
        long uptime;
        String type;
        String metricName;
        String metricDescription;
        String metricId;
        String tags;
        double count;
        double mean;
        double max;
        double total;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

