/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="health", description={"Get health check status of running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListHealth
extends ProcessWatchCommand {
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--level"}, description={"Level of details: full, or default"}, defaultValue="default")
    String level;
    @CommandLine.Option(names={"--down"}, description={"Show only checks which are DOWN"})
    boolean down;
    @CommandLine.Option(names={"--ready"}, description={"Show only readiness checks"})
    boolean ready;
    @CommandLine.Option(names={"--live"}, description={"Show only liveness checks"})
    boolean live;
    @CommandLine.Option(names={"--trace"}, description={"Include stack-traces in error messages"}, defaultValue="false")
    boolean trace;
    @CommandLine.Option(names={"--depth"}, description={"Max depth of stack-trace"}, defaultValue="1")
    int depth;

    public ListHealth(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        List traces;
        ArrayList rows = new ArrayList();
        if (this.trace && this.depth <= 1) {
            this.depth = Integer.MAX_VALUE;
        }
        List<Long> pids = this.findPids("*");
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                JsonObject hc = (JsonObject)root.get((Object)"healthChecks");
                if (hc == null) {
                    return;
                }
                JsonArray array = (JsonArray)hc.get((Object)"checks");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject o = (JsonObject)array.get(i);
                    Row row = new Row();
                    row.pid = Long.toString(ph.pid());
                    row.uptime = ListHealth.extractSince(ph);
                    row.ago = TimeUtils.printSince((long)row.uptime);
                    row.name = context.getString("name");
                    if ("CamelJBang".equals(row.name)) {
                        row.name = ProcessHelper.extractName(root, ph);
                    }
                    row.id = o.getString("id");
                    row.group = o.getString("group");
                    row.state = o.getString("state");
                    row.readiness = o.getBoolean("readiness");
                    row.liveness = o.getBoolean("liveness");
                    row.message = o.getString("message");
                    row.stackTrace = (List)o.getCollection("stackTrace");
                    JsonObject d = (JsonObject)o.get((Object)"details");
                    if (d != null) {
                        long delta;
                        ZonedDateTime zdt;
                        row.total = d.getString("invocation.count");
                        row.success = d.getString("success.count");
                        row.failure = d.getString("failure.count");
                        String kind = d.getString("check.kind");
                        if ("READINESS".equals(kind)) {
                            row.liveness = false;
                        } else if ("LIVENESS".equals(kind)) {
                            row.readiness = false;
                        }
                        String time = d.getString("invocation.time");
                        if (time != null) {
                            zdt = ZonedDateTime.parse(time);
                            delta = Math.abs(ZonedDateTime.now().until(zdt, ChronoUnit.MILLIS));
                            row.sinceLast = TimeUtils.printAge((long)delta);
                        }
                        if ((time = d.getString("success.start.time")) != null) {
                            zdt = ZonedDateTime.parse(time);
                            delta = Math.abs(ZonedDateTime.now().until(zdt, ChronoUnit.MILLIS));
                            row.sinceStartSuccess = TimeUtils.printAge((long)delta);
                        }
                        if ((time = d.getString("failure.start.time")) != null) {
                            zdt = ZonedDateTime.parse(time);
                            delta = Math.abs(ZonedDateTime.now().until(zdt, ChronoUnit.MILLIS));
                            row.sinceStartFailure = TimeUtils.printAge((long)delta);
                        }
                        for (Map.Entry entry : d.entrySet()) {
                            String k = (String)entry.getKey();
                            if (HealthCheckHelper.isReservedKey((String)k)) continue;
                            if (row.customMeta == null) {
                                row.customMeta = new TreeMap<String, Object>();
                            }
                            row.customMeta.put(k, entry.getValue());
                        }
                    }
                    boolean add = true;
                    if (this.live && !row.liveness) {
                        add = false;
                    }
                    if (this.ready && !row.readiness) {
                        add = false;
                    }
                    if (this.down && !row.state.equals("DOWN")) {
                        add = false;
                    }
                    if ((this.level == null || "default".equals(this.level)) && row.state.equals("UP") && "camel".equals(row.group) && (row.id.startsWith("route:") || row.id.startsWith("consumer:"))) {
                        add = false;
                    }
                    if (!add) continue;
                    rows.add(row);
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.ago), new Column().header("ID").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getId), new Column().header("RL").minWidth(4).maxWidth(4).with(this::getLR), new Column().header("STATUS").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.CENTER).with(r -> r.state), new Column().header("RATE").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.RIGHT).with(this::getRate), new Column().header("SINCE").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.RIGHT).with(this::getSince), new Column().header("MESSAGE").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(r -> r.message))));
        }
        if (this.trace && !(traces = rows.stream().filter(r -> r.stackTrace != null && !r.stackTrace.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            for (Row row : traces) {
                this.printer().println("\n");
                this.printer().println(StringHelper.fillChars((char)'-', (int)120));
                this.printer().println(StringHelper.padString((int)1, (int)55) + "STACK-TRACE");
                this.printer().println(StringHelper.fillChars((char)'-', (int)120));
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("\tPID: %s%n", row.pid));
                sb.append(String.format("\tNAME: %s%n", row.name));
                sb.append(String.format("\tAGE: %s%n", row.ago));
                sb.append(String.format("\tCHECK-ID: %s%n", this.getId(row)));
                sb.append(String.format("\tSTATE: %s%n", row.state));
                sb.append(String.format("\tRATE: %s%n", row.failure));
                sb.append(String.format("\tSINCE: %s%n", row.sinceStartFailure));
                if (row.customMeta != null) {
                    sb.append(String.format("\tMETADATA:%n", new Object[0]));
                    row.customMeta.forEach((k, v) -> sb.append(String.format("\t\t%s = %s%n", k, v)));
                }
                sb.append(String.format("\tMESSAGE: %s%n", row.message));
                for (int i = 0; i < this.depth && i < row.stackTrace.size(); ++i) {
                    sb.append(String.format("\t%s%n", row.stackTrace.get(i)));
                }
                this.printer().println(sb.toString());
            }
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected String getId(Row r) {
        if (r.group != null) {
            return r.group + "/" + r.id;
        }
        return r.id;
    }

    protected String getLR(Row r) {
        if (r.readiness && r.liveness) {
            return "RL";
        }
        if (r.readiness) {
            return "R";
        }
        if (r.liveness) {
            return "L";
        }
        return "";
    }

    protected String getRate(Row r) {
        String s1 = r.total != null && !"0".equals(r.total) ? r.total : "-";
        String s2 = r.success != null && !"0".equals(r.success) ? r.success : "-";
        String s3 = r.failure != null && !"0".equals(r.failure) ? r.failure : "-";
        return s1 + "/" + s2 + "/" + s3;
    }

    protected String getSince(Row r) {
        String s1 = r.sinceLast != null ? r.sinceLast : "-";
        String s2 = r.sinceStartSuccess != null ? r.sinceStartSuccess : "-";
        String s3 = r.sinceStartFailure != null ? r.sinceStartFailure : "-";
        return s1 + "/" + s2 + "/" + s3;
    }

    private static class Row {
        String pid;
        String name;
        String ago;
        long uptime;
        String id;
        String group;
        String state;
        boolean readiness;
        boolean liveness;
        String total;
        String success;
        String failure;
        String sinceLast;
        String sinceStartSuccess;
        String sinceStartFailure;
        String message;
        List<String> stackTrace;
        Map<String, Object> customMeta;

        private Row() {
        }
    }
}

