/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.CamelProcessorStatus;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="groovy", description={"Groovy Sources used of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListGroovy
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=CamelProcessorStatus.PidNameCompletionCandidates.class, description={"Sort by pid or name"}, defaultValue="pid")
    String sort;

    public ListGroovy(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                JsonObject jo = (JsonObject)root.get((Object)"groovy");
                if (jo != null) {
                    jo = (JsonObject)jo.get((Object)"compiler");
                }
                if (jo != null) {
                    row = row.copy();
                    row.compiledCounter = jo.getInteger("compiledCounter");
                    row.preloaddCounter = jo.getInteger("preloadedCounter");
                    row.classesSize = jo.getInteger("classesSize");
                    row.time = jo.getLong("compiledTime");
                    row.last = jo.getLong("lastCompilationTimestamp");
                    row.compiledClasses.clear();
                    JsonArray arr = (JsonArray)jo.getCollection("classes");
                    for (int i = 0; arr != null && i < arr.size(); ++i) {
                        row.compiledClasses.add(arr.getString(i));
                    }
                    rows.add(row);
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("PRELOAD").headerAlign(HorizontalAlign.CENTER).with(r -> "" + r.preloaddCounter), new Column().header("COMPILE").headerAlign(HorizontalAlign.CENTER).with(r -> "" + r.compiledCounter), new Column().header("TIME").headerAlign(HorizontalAlign.CENTER).with(this::getTime), new Column().header("SINCE").headerAlign(HorizontalAlign.CENTER).with(this::getLast), new Column().header("CLASSES").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.ELLIPSIS_LEFT).with(this::getClasses))));
        }
        return 0;
    }

    private String getTime(Row r) {
        return TimeUtils.printDuration((long)r.time, (boolean)true);
    }

    private String getLast(Row r) {
        if (r.last > 0L) {
            return TimeUtils.printSince((long)r.last);
        }
        return null;
    }

    private String getClasses(Row r) {
        if (r.compiledClasses.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", r.compiledClasses);
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
        }
        return 0;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        int compiledCounter;
        int preloaddCounter;
        int classesSize;
        long time;
        long last;
        List<String> compiledClasses = new ArrayList<String>();

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

