/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="event", description={"Get latest events of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListEvent
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--filter"}, description={"Filter event by event type: context, route, or exchange"})
    String filter;

    public ListEvent(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                if (this.filter == null || this.filter.contains("context")) {
                    ListEvent.fetchEvents(root, row, "events", rows);
                }
                if (this.filter == null || this.filter.contains("route")) {
                    ListEvent.fetchEvents(root, row, "routeEvents", rows);
                }
                if (this.filter == null || this.filter.contains("exchange")) {
                    ListEvent.fetchEvents(root, row, "exchangeEvents", rows);
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).with(r -> r.type), new Column().header("AGE").dataAlign(HorizontalAlign.RIGHT).with(this::getTimestamp), new Column().header("MESSAGE").dataAlign(HorizontalAlign.LEFT).with(r -> r.message))));
        }
        return 0;
    }

    private static void fetchEvents(JsonObject root, Row row, String type, List<Row> rows) {
        JsonArray arr;
        JsonObject jo = (JsonObject)root.get((Object)"events");
        if (jo != null && (arr = (JsonArray)jo.get((Object)type)) != null) {
            for (Object o : arr) {
                row = row.copy();
                jo = (JsonObject)o;
                row.type = jo.getString("type");
                Long ts = jo.getLong("timestamp");
                if (ts != null) {
                    row.timestamp = ts;
                }
                row.exchangeId = jo.getString("exchangeId");
                row.message = jo.getString("message");
                rows.add(row);
            }
        }
    }

    private String getTimestamp(Row r) {
        if (r.timestamp > 0L) {
            return TimeUtils.printSince((long)r.timestamp);
        }
        return "";
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.timestamp, o2.timestamp) * negate;
            }
        }
        return 0;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String type;
        long timestamp;
        String exchangeId;
        String message;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

