/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="circuit-breaker", description={"Get status of Circuit Breaker EIPs"}, sortOptions=false, showDefaultValues=true)
public class ListCircuitBreaker
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;

    public ListCircuitBreaker(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject jo;
                int i;
                JsonArray arr;
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = ListCircuitBreaker.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                Row baseRow = row.copy();
                JsonObject mo = (JsonObject)root.get((Object)"resilience4j");
                if (mo != null && (arr = (JsonArray)mo.get((Object)"circuitBreakers")) != null) {
                    for (i = 0; i < arr.size(); ++i) {
                        row = baseRow.copy();
                        jo = (JsonObject)arr.get(i);
                        row.component = "resilience4j";
                        row.id = jo.getString("id");
                        row.routeId = jo.getString("routeId");
                        row.state = jo.getString("state");
                        row.bufferedCalls = jo.getInteger("bufferedCalls");
                        row.successfulCalls = jo.getInteger("successfulCalls");
                        row.failedCalls = jo.getInteger("failedCalls");
                        row.notPermittedCalls = jo.getLong("notPermittedCalls");
                        row.failureRate = jo.getDouble("failureRate");
                        rows.add(row);
                    }
                }
                if ((mo = (JsonObject)root.get((Object)"fault-tolerance")) != null && (arr = (JsonArray)mo.get((Object)"circuitBreakers")) != null) {
                    for (i = 0; i < arr.size(); ++i) {
                        row = baseRow.copy();
                        jo = (JsonObject)arr.get(i);
                        row.component = "fault-tolerance";
                        row.id = jo.getString("id");
                        row.routeId = jo.getString("routeId");
                        row.state = jo.getString("state");
                        rows.add(row);
                    }
                }
                if ((mo = (JsonObject)root.get((Object)"circuit-breaker")) != null && (arr = (JsonArray)mo.get((Object)"circuitBreakers")) != null) {
                    for (i = 0; i < arr.size(); ++i) {
                        row = baseRow.copy();
                        jo = (JsonObject)arr.get(i);
                        row.component = "core";
                        row.id = jo.getString("routeId");
                        row.routeId = jo.getString("routeId");
                        row.state = jo.getString("state");
                        row.successfulCalls = jo.getInteger("successfulCalls");
                        row.failedCalls = jo.getInteger("failedCalls");
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("COMPONENT").dataAlign(HorizontalAlign.LEFT).with(r -> r.component), new Column().header("ROUTE").dataAlign(HorizontalAlign.LEFT).with(r -> r.routeId), new Column().header("ID").dataAlign(HorizontalAlign.LEFT).with(r -> r.id), new Column().header("STATE").dataAlign(HorizontalAlign.LEFT).with(r -> r.state), new Column().header("PENDING").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(this::getPending), new Column().header("SUCCESS").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(this::getSuccess), new Column().header("FAIL").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.RIGHT).with(this::getFailure), new Column().header("REJECT").headerAlign(HorizontalAlign.RIGHT).dataAlign(HorizontalAlign.RIGHT).with(this::getReject))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private String getFailure(Row r) {
        if (r.failedCalls <= 0) {
            return "";
        }
        if (r.failureRate > 0.0) {
            return r.failedCalls + " (" + String.format("%.0f", r.failureRate) + "%)";
        }
        return Integer.toString(r.failedCalls);
    }

    private String getPending(Row r) {
        if ("resilience4j".equals(r.component)) {
            return Integer.toString(r.bufferedCalls);
        }
        return "";
    }

    private String getSuccess(Row r) {
        if ("resilience4j".equals(r.component) || "core".equals(r.component)) {
            return Integer.toString(r.successfulCalls);
        }
        return "";
    }

    private String getReject(Row r) {
        if ("resilience4j".equals(r.component)) {
            return Long.toString(r.notPermittedCalls);
        }
        return "";
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String age;
        long uptime;
        String component;
        String id;
        String routeId;
        String state;
        int bufferedCalls;
        int successfulCalls;
        int failedCalls;
        long notPermittedCalls;
        double failureRate;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

