/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import java.awt.Desktop;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.Jolokia;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.tooling.maven.MavenArtifact;
import picocli.CommandLine;

@CommandLine.Command(name="hawtio", description={"Launch Hawtio web console"}, sortOptions=false, showDefaultValues=true)
public class Hawtio
extends CamelCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name;
    @CommandLine.Option(names={"--version"}, description={"Version of the Hawtio web console"}, defaultValue="4.4.0")
    String version = "4.4.0";
    @CommandLine.Option(names={"--port"}, description={"Port number to use for Hawtio web console (port 8888 by default)"}, defaultValue="8888")
    int port = 8888;
    @CommandLine.Option(names={"--openUrl"}, description={"To automatic open Hawtio web console in the web browser"}, defaultValue="true")
    boolean openUrl = true;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile long pid;

    public Hawtio(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        int exit;
        if (this.name == null) {
            exit = this.callHawtio();
        } else {
            try {
                exit = this.connectJolokia();
                if (exit == 0) {
                    exit = this.callHawtio();
                }
            }
            finally {
                this.disconnectJolokia();
            }
        }
        return exit;
    }

    protected Integer connectJolokia() throws Exception {
        Jolokia jolokia = new Jolokia(this.getMain());
        jolokia.name = this.name;
        int exit = jolokia.call();
        this.pid = jolokia.getPid();
        return exit;
    }

    protected void disconnectJolokia() throws Exception {
        Jolokia jolokia = new Jolokia(this.getMain());
        jolokia.name = Long.toString(this.pid);
        jolokia.stop = true;
        jolokia.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer callHawtio() throws Exception {
        ClassLoader cl = this.createClassLoader();
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader(cl);
        downloader.start();
        downloader.downloadDependency("io.hawt", "hawtio-embedded", this.version);
        MavenArtifact ma = downloader.downloadArtifact("io.hawt", "hawtio-war:war", this.version);
        if (ma == null) {
            this.printer().printErr("Cannot download io.hawt:hawtio-war:war:" + this.version);
            return 1;
        }
        String war = ma.getFile().getAbsolutePath();
        try {
            System.setProperty("hawtio.authenticationEnabled", "false");
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass("io.hawt.embedded.Main");
            Object hawt = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = clazz.getMethod("setWar", String.class);
            ObjectHelper.invokeMethod((Method)m, hawt, (Object[])new Object[]{war});
            m = clazz.getMethod("setPort", Integer.class);
            ObjectHelper.invokeMethod((Method)m, hawt, (Object[])new Object[]{this.port});
            m = clazz.getMethod("run", new Class[0]);
            ObjectHelper.invokeMethod((Method)m, hawt, (Object[])new Object[0]);
            if (this.openUrl) {
                String url = "http://localhost:" + this.port + "/hawtio";
                System.setProperty("hawtio.url", url);
                if (this.openUrl && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (Exception e) {
                        this.printer().printErr("Failed to open browser session, to access Hawtio open url: " + url);
                    }
                }
            }
            this.installHangupInterceptor();
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.printer().printErr("Interrupted while launching Hawtio");
            Integer n = 1;
            return n;
        }
        catch (Exception e) {
            this.printer().printErr("Cannot launch Hawtio due to: " + e.getMessage());
            Integer n = 1;
            return n;
        }
        finally {
            downloader.close();
        }
        return 0;
    }

    private ClassLoader createClassLoader() {
        return new DependencyDownloaderClassLoader(null);
    }

    private void installHangupInterceptor() {
        Thread task = new Thread(this.shutdownLatch::countDown);
        Runtime.getRuntime().addShutdownHook(task);
    }
}

