/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="route-group", description={"Get status of Camel route groups"}, sortOptions=false, showDefaultValues=true)
public class CamelRouteGroupStatus
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeGroupCompletionCandidates.class, description={"Sort by pid, name, age or group"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--limit"}, description={"Filter groups by limiting to the given number of rows"})
    int limit;
    @CommandLine.Option(names={"--filter-mean"}, description={"Filter groups that must be slower than the given time (ms)"})
    long mean;
    @CommandLine.Option(names={"--running"}, description={"Only include running groups"})
    boolean running;
    @CommandLine.Option(names={"--filter"}, description={"Filter groups by name"})
    String[] filter;

    public CamelRouteGroupStatus(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        AtomicBoolean remoteVisible = new AtomicBoolean();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                JsonArray array = (JsonArray)root.get((Object)"routeGroups");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject o = (JsonObject)array.get(i);
                    Row row = new Row();
                    row.name = context.getString("name");
                    if ("CamelJBang".equals(row.name)) {
                        row.name = ProcessHelper.extractName(root, ph);
                    }
                    row.pid = Long.toString(ph.pid());
                    row.group = o.getString("group");
                    row.size = o.getInteger("size");
                    row.routeIds = (List)o.getCollection("routeIds");
                    row.state = o.getString("state");
                    row.age = o.getString("uptime");
                    row.uptime = row.age != null ? TimeUtils.toMilliSeconds((String)row.age) : 0L;
                    Map stats = o.getMap("statistics");
                    if (stats != null) {
                        long time;
                        Object coverage;
                        Object thp;
                        Object load = stats.get("load01");
                        if (load != null) {
                            row.load01 = load.toString();
                        }
                        if ((load = stats.get("load05")) != null) {
                            row.load05 = load.toString();
                        }
                        if ((load = stats.get("load15")) != null) {
                            row.load15 = load.toString();
                        }
                        if ((thp = stats.get("exchangesThroughput")) != null) {
                            row.throughput = thp.toString();
                        }
                        if ((coverage = stats.get("coverage")) != null) {
                            row.coverage = coverage.toString();
                        }
                        row.total = stats.get("exchangesTotal").toString();
                        row.inflight = stats.get("exchangesInflight").toString();
                        row.failed = stats.get("exchangesFailed").toString();
                        row.mean = stats.get("meanProcessingTime").toString();
                        if ("-1".equals(row.mean)) {
                            row.mean = null;
                        }
                        row.max = stats.get("maxProcessingTime").toString();
                        row.min = stats.get("minProcessingTime").toString();
                        Object last = stats.get("lastProcessingTime");
                        if (last != null) {
                            row.last = last.toString();
                        }
                        if ((last = stats.get("deltaProcessingTime")) != null) {
                            row.delta = last.toString();
                        }
                        if ((last = stats.get("lastCreatedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastStarted = TimeUtils.printSince((long)time);
                        }
                        if ((last = stats.get("lastCompletedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastCompleted = TimeUtils.printSince((long)time);
                        }
                        if ((last = stats.get("lastFailedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastFailed = TimeUtils.printSince((long)time);
                        }
                    }
                    boolean add = true;
                    if (this.mean > 0L && (row.mean == null || Long.parseLong(row.mean) < this.mean)) {
                        add = false;
                    }
                    if (this.limit > 0 && rows.size() >= this.limit) {
                        add = false;
                    }
                    if (add && this.filter != null) {
                        boolean match = false;
                        for (String f : this.filter) {
                            if (match) continue;
                            match = PatternHelper.matchPattern((String)row.group, (String)f);
                        }
                        if (!match) {
                            add = false;
                        }
                    }
                    if (add && this.running) {
                        add = "Started".equals(row.state);
                    }
                    if (!add) continue;
                    rows.add(row);
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printTable(rows);
        }
        return 0;
    }

    protected void printTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("GROUP").dataAlign(HorizontalAlign.LEFT).maxWidth(20, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getGroup), new Column().header("ROUTES").dataAlign(HorizontalAlign.RIGHT).headerAlign(HorizontalAlign.CENTER).with(r -> "" + r.size), new Column().header("STATUS").dataAlign(HorizontalAlign.LEFT).headerAlign(HorizontalAlign.CENTER).with(r -> r.state), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("COVER").with(this::getCoverage), new Column().header("MSG/S").with(this::getThroughput), new Column().header("TOTAL").with(this::getTotal), new Column().header("FAIL").with(this::getFailed), new Column().header("INFLIGHT").with(this::getInflight), new Column().header("MEAN").with(r -> r.mean), new Column().header("MIN").with(r -> r.min), new Column().header("MAX").with(r -> r.max), new Column().header("LAST").with(r -> r.last), new Column().header("DELTA").with(this::getDelta), new Column().header("SINCE-LAST").with(this::getSinceLast))));
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "group": {
                return o1.name.compareToIgnoreCase(o2.group) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected String getSinceLast(Row r) {
        String s1 = r.sinceLastStarted != null ? r.sinceLastStarted : "-";
        String s2 = r.sinceLastCompleted != null ? r.sinceLastCompleted : "-";
        String s3 = r.sinceLastFailed != null ? r.sinceLastFailed : "-";
        return s1 + "/" + s2 + "/" + s3;
    }

    protected String getThroughput(Row r) {
        String s = r.throughput;
        if (s == null || s.isEmpty()) {
            s = "";
        }
        return s;
    }

    protected String getCoverage(Row r) {
        String s = r.coverage;
        if (s == null || s.isEmpty()) {
            s = "";
        }
        return s;
    }

    protected String getGroup(Row r) {
        return r.group;
    }

    protected String getDelta(Row r) {
        if (r.delta != null) {
            if (r.delta.startsWith("-")) {
                return r.delta;
            }
            if (!"0".equals(r.delta)) {
                return "+" + r.delta;
            }
        }
        return r.delta;
    }

    protected String getTotal(Row r) {
        return r.total;
    }

    protected String getFailed(Row r) {
        return r.failed;
    }

    protected String getInflight(Row r) {
        return r.inflight;
    }

    static class Row {
        String pid;
        String name;
        long uptime;
        String group;
        int size;
        List<String> routeIds;
        String state;
        String age;
        String coverage;
        String throughput;
        String total;
        String failed;
        String inflight;
        String mean;
        String max;
        String min;
        String last;
        String delta;
        String sinceLastStarted;
        String sinceLastCompleted;
        String sinceLastFailed;
        String load01;
        String load05;
        String load15;

        Row() {
        }
    }

    public static class PidNameAgeGroupCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "age", "group").iterator();
        }
    }
}

